/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.IndexBackedConstraintDescriptor;

public class UniquePropertyValueValidationException
extends ConstraintValidationException {
    private final Set<IndexEntryConflictException> conflicts;

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, IndexEntryConflictException conflict) {
        this(constraint, phase, Collections.singleton(conflict));
    }

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Set<IndexEntryConflictException> conflicts) {
        super(constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data");
        this.conflicts = conflicts;
    }

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Throwable cause) {
        super(constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", cause);
        this.conflicts = Collections.emptySet();
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        LabelSchemaDescriptor schema = (LabelSchemaDescriptor)this.constraint.schema();
        StringBuilder message = new StringBuilder();
        Iterator<IndexEntryConflictException> iterator = this.conflicts.iterator();
        while (iterator.hasNext()) {
            IndexEntryConflictException conflict = iterator.next();
            message.append(conflict.evidenceMessage(tokenNameLookup, schema));
            if (!iterator.hasNext()) continue;
            message.append(System.lineSeparator());
        }
        return message.toString();
    }

    public Set<IndexEntryConflictException> conflicts() {
        return this.conflicts;
    }
}

