/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.UpdateCountingIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class OnlineIndexProxy
implements IndexProxy {
    private final long indexId;
    private final NewIndexDescriptor descriptor;
    final IndexAccessor accessor;
    private final IndexStoreView storeView;
    private final SchemaIndexProvider.Descriptor providerDescriptor;
    private final IndexCountsRemover indexCountsRemover;
    private final boolean forcedIdempotentMode;

    public OnlineIndexProxy(long indexId, NewIndexDescriptor descriptor, IndexAccessor accessor, IndexStoreView storeView, SchemaIndexProvider.Descriptor providerDescriptor, boolean forcedIdempotentMode) {
        this.indexId = indexId;
        this.descriptor = descriptor;
        this.storeView = storeView;
        this.providerDescriptor = providerDescriptor;
        this.accessor = accessor;
        this.forcedIdempotentMode = forcedIdempotentMode;
        this.indexCountsRemover = new IndexCountsRemover(storeView, indexId);
    }

    @Override
    public void start() {
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return this.updateCountingUpdater(this.accessor.newUpdater(this.forcedIdempotentMode ? IndexUpdateMode.RECOVERY : mode));
    }

    private IndexUpdater updateCountingUpdater(IndexUpdater indexUpdater) {
        return new UpdateCountingIndexUpdater(this.storeView, this.indexId, indexUpdater);
    }

    @Override
    public Future<Void> drop() throws IOException {
        this.indexCountsRemover.remove();
        this.accessor.drop();
        return FutureAdapter.VOID;
    }

    @Override
    public NewIndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.ONLINE;
    }

    @Override
    public void force() throws IOException {
        this.accessor.force();
    }

    @Override
    public void flush() throws IOException {
        this.accessor.flush();
    }

    @Override
    public Future<Void> close() throws IOException {
        this.accessor.close();
        return FutureAdapter.VOID;
    }

    @Override
    public IndexReader newReader() {
        return this.accessor.newReader();
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException, InterruptedException {
        return false;
    }

    @Override
    public void activate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is ONLINE");
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return PopulationProgress.DONE;
    }

    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        return this.accessor.snapshotFiles();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[accessor:" + this.accessor + ", descriptor:" + this.descriptor + "]";
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        this.accessor.verifyDeferredConstraints(propertyAccessor);
    }
}

