/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new.constaints;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;

public class NodeExistenceConstraintDescriptor
extends ConstraintDescriptor {
    private LabelSchemaDescriptor schema;

    NodeExistenceConstraintDescriptor(LabelSchemaDescriptor schema) {
        super(ConstraintDescriptor.Type.EXISTS);
        this.schema = schema;
    }

    @Override
    public LabelSchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public String prettyPrint(TokenNameLookup tokenNameLookup) {
        String labelName = this.escapeLabelOrRelTyp(tokenNameLookup.labelGetName(this.schema.getLabelId()));
        String nodeName = labelName.toLowerCase();
        String propertyName = tokenNameLookup.propertyKeyGetName(this.schema.getPropertyId());
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT exists(%s.%s)", nodeName, labelName, nodeName, propertyName);
    }
}

