/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new.constaints;

import java.util.Iterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.schema.IndexDescriptorFactory;
import org.neo4j.kernel.api.schema.RelationshipPropertyDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaBoundary;
import org.neo4j.kernel.api.schema_new.SchemaComputer;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptorFactory;

public class ConstraintBoundary {
    public static PropertyConstraint map(ConstraintDescriptor descriptor) {
        return descriptor.schema().computeWith(new BoundaryTransformer(descriptor));
    }

    public static UniquenessConstraint mapUnique(ConstraintDescriptor descriptor) {
        return (UniquenessConstraint)descriptor.schema().computeWith(new BoundaryTransformer(descriptor));
    }

    public static NodePropertyConstraint mapNode(ConstraintDescriptor descriptor) {
        return (NodePropertyConstraint)descriptor.schema().computeWith(new BoundaryTransformer(descriptor));
    }

    public static RelationshipPropertyConstraint mapRelationship(ConstraintDescriptor descriptor) {
        return (RelationshipPropertyConstraint)descriptor.schema().computeWith(new BoundaryTransformer(descriptor));
    }

    public static ConstraintDescriptor map(PropertyConstraint constraint) {
        if (constraint instanceof UniquenessConstraint) {
            UniquenessConstraint c = (UniquenessConstraint)constraint;
            return ConstraintDescriptorFactory.uniqueForSchema(SchemaBoundary.map(c.descriptor()));
        }
        if (constraint instanceof NodePropertyExistenceConstraint) {
            NodePropertyExistenceConstraint c = (NodePropertyExistenceConstraint)constraint;
            return ConstraintDescriptorFactory.existsForSchema(SchemaBoundary.map(c.descriptor()));
        }
        if (constraint instanceof RelationshipPropertyExistenceConstraint) {
            RelationshipPropertyExistenceConstraint c = (RelationshipPropertyExistenceConstraint)constraint;
            return ConstraintDescriptorFactory.existsForSchema(SchemaBoundary.map(c.descriptor()));
        }
        throw new IllegalStateException("Unknown constraint type " + constraint.getClass().getSimpleName());
    }

    public static <T extends PropertyConstraint> Iterator<ConstraintDescriptor> mapToNew(Iterator<T> constraints) {
        return Iterators.map(ConstraintBoundary::map, constraints);
    }

    public static Iterator<PropertyConstraint> map(Iterator<ConstraintDescriptor> constraints) {
        return Iterators.map(ConstraintBoundary::map, constraints);
    }

    private static class BoundaryTransformer
    implements SchemaComputer<PropertyConstraint> {
        private final ConstraintDescriptor descriptor;

        BoundaryTransformer(ConstraintDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public PropertyConstraint computeSpecific(LabelSchemaDescriptor schema) {
            switch (this.descriptor.type()) {
                case UNIQUE: {
                    return new UniquenessConstraint(IndexDescriptorFactory.getNodePropertyDescriptor(schema.getLabelId(), schema.getPropertyId()));
                }
                case EXISTS: {
                    return new NodePropertyExistenceConstraint(IndexDescriptorFactory.getNodePropertyDescriptor(schema.getLabelId(), schema.getPropertyId()));
                }
            }
            throw new UnsupportedOperationException("Although we cannot get here, this has not been implemented.");
        }

        @Override
        public PropertyConstraint computeSpecific(RelationTypeSchemaDescriptor schema) {
            return new RelationshipPropertyExistenceConstraint(new RelationshipPropertyDescriptor(schema.getRelTypeId(), schema.getPropertyId()));
        }
    }
}

