/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new;

import org.neo4j.kernel.api.TokenNameLookup;

public class SchemaUtil {
    public static TokenNameLookup idTokenNameLookup = new TokenNameLookup(){

        @Override
        public String labelGetName(int labelId) {
            return String.format("label[%d]", labelId);
        }

        @Override
        public String relationshipTypeGetName(int relationshipTypeId) {
            return String.format("relType[%d]", relationshipTypeId);
        }

        @Override
        public String propertyKeyGetName(int propertyKeyId) {
            return String.format("property[%d]", propertyKeyId);
        }
    };

    private SchemaUtil() {
    }

    public static String niceProperties(TokenNameLookup tokenNameLookup, int[] propertyIds) {
        CharSequence[] properties = new String[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            properties[i] = tokenNameLookup.propertyKeyGetName(propertyIds[i]);
        }
        return String.join((CharSequence)", ", properties);
    }
}

