/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.transaction.state.LabelChangeSummary;

public class NodeUpdates {
    private final long nodeId;
    private final long[] labelsBefore;
    private final long[] labelsAfter;
    private final LabelChangeSummary labelChangeSummary;
    private final Map<Integer, Object> propertiesBefore = new HashMap<Integer, Object>();
    private final Map<Integer, Object> propertiesAfter = new HashMap<Integer, Object>();
    private final Map<Integer, Object> propertiesUnchanged = new HashMap<Integer, Object>();

    public static Builder forNode(long nodeId) {
        return new Builder(new NodeUpdates(nodeId, ShortArray.EMPTY_LONG_ARRAY, ShortArray.EMPTY_LONG_ARRAY));
    }

    public static Builder forNode(long nodeId, long[] labels) {
        return new Builder(new NodeUpdates(nodeId, labels, labels));
    }

    public static Builder forNode(long nodeId, long[] labelsBefore, long[] labelsAfter) {
        return new Builder(new NodeUpdates(nodeId, labelsBefore, labelsAfter));
    }

    private NodeUpdates(long nodeId, long[] labelsBefore, long[] labelsAfter) {
        this.nodeId = nodeId;
        this.labelsBefore = labelsBefore;
        this.labelsAfter = labelsAfter;
        this.labelChangeSummary = new LabelChangeSummary(labelsBefore, labelsAfter);
    }

    public final long getNodeId() {
        return this.nodeId;
    }

    public Optional<IndexEntryUpdate> forIndex(NewIndexDescriptor index) {
        if (index.schema().getPropertyIds().length > 1) {
            return this.getMultiPropertyIndexUpdate(index);
        }
        return this.getSingePropertyIndexUpdate(index);
    }

    private Optional<IndexEntryUpdate> getMultiPropertyIndexUpdate(NewIndexDescriptor index) {
        int[] propertyKeyIds = index.schema().getPropertyIds();
        boolean labelExistsBefore = Arrays.binarySearch(this.labelsBefore, (long)index.schema().getLabelId()) >= 0;
        boolean labelExistsAfter = Arrays.binarySearch(this.labelsAfter, (long)index.schema().getLabelId()) >= 0;
        HashSet<Integer> added = new HashSet<Integer>();
        HashSet<Integer> removed = new HashSet<Integer>();
        HashSet<Integer> changed = new HashSet<Integer>();
        HashSet<Integer> unchanged = new HashSet<Integer>();
        HashSet<Integer> unknown = new HashSet<Integer>();
        Object[] before = new Object[propertyKeyIds.length];
        Object[] after = new Object[propertyKeyIds.length];
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            int propertyKeyId = propertyKeyIds[i];
            before[i] = this.propertiesBefore.get(propertyKeyId);
            after[i] = this.propertiesAfter.get(propertyKeyId);
            Object unchangedValue = this.propertiesUnchanged.get(propertyKeyId);
            if (before[i] != null) {
                if (after[i] != null) {
                    changed.add(propertyKeyId);
                    continue;
                }
                removed.add(propertyKeyId);
                continue;
            }
            if (after[i] != null) {
                added.add(propertyKeyId);
                continue;
            }
            if (unchangedValue != null) {
                before[i] = unchangedValue;
                after[i] = unchangedValue;
                unchanged.add(propertyKeyId);
                continue;
            }
            unknown.add(propertyKeyId);
            break;
        }
        if (unknown.size() == 0) {
            if (added.size() > 0) {
                if (labelExistsAfter) {
                    return Optional.of(IndexEntryUpdate.add(this.nodeId, index, after));
                }
            } else if (removed.size() > 0) {
                if (labelExistsBefore) {
                    return Optional.of(IndexEntryUpdate.remove(this.nodeId, index, before));
                }
            } else if (changed.size() > 0) {
                if (labelExistsBefore && labelExistsAfter) {
                    return Optional.of(IndexEntryUpdate.change(this.nodeId, index, before, after));
                }
                if (labelExistsAfter) {
                    return Optional.of(IndexEntryUpdate.add(this.nodeId, index, after));
                }
                if (labelExistsBefore) {
                    return Optional.of(IndexEntryUpdate.remove(this.nodeId, index, before));
                }
            } else if (unchanged.size() >= 0) {
                if (!labelExistsBefore && labelExistsAfter) {
                    return Optional.of(IndexEntryUpdate.add(this.nodeId, index, after));
                }
                if (labelExistsBefore && !labelExistsAfter) {
                    return Optional.of(IndexEntryUpdate.remove(this.nodeId, index, before));
                }
            }
        }
        return Optional.empty();
    }

    private Optional<IndexEntryUpdate> getSingePropertyIndexUpdate(NewIndexDescriptor index) {
        boolean labelExistsAfter;
        int propertyKeyId = index.schema().getPropertyId();
        Object before = this.propertiesBefore.get(propertyKeyId);
        Object after = this.propertiesAfter.get(propertyKeyId);
        Object unchanged = this.propertiesUnchanged.get(propertyKeyId);
        boolean labelExistsBefore = Arrays.binarySearch(this.labelsBefore, (long)index.schema().getLabelId()) >= 0;
        boolean bl = labelExistsAfter = Arrays.binarySearch(this.labelsAfter, (long)index.schema().getLabelId()) >= 0;
        if (before != null) {
            if (after != null) {
                if (labelExistsBefore && labelExistsAfter) {
                    return Optional.of(IndexEntryUpdate.change(this.nodeId, index, before, after));
                }
                if (labelExistsAfter) {
                    return Optional.of(IndexEntryUpdate.add(this.nodeId, index, after));
                }
                if (labelExistsBefore) {
                    return Optional.of(IndexEntryUpdate.remove(this.nodeId, index, before));
                }
            } else if (labelExistsBefore) {
                return Optional.of(IndexEntryUpdate.remove(this.nodeId, index, before));
            }
        } else if (after != null) {
            if (labelExistsAfter) {
                return Optional.of(IndexEntryUpdate.add(this.nodeId, index, after));
            }
        } else if (unchanged != null) {
            if (!labelExistsBefore && labelExistsAfter) {
                return Optional.of(IndexEntryUpdate.add(this.nodeId, index, unchanged));
            }
            if (labelExistsBefore && !labelExistsAfter) {
                return Optional.of(IndexEntryUpdate.remove(this.nodeId, index, unchanged));
            }
        }
        return Optional.empty();
    }

    public void setProperties(PropertyUpdate propertyUpdates, DefinedProperty[] definedProperties) {
        this.propertiesBefore.clear();
        this.propertiesAfter.clear();
        this.propertiesUnchanged.clear();
        PropertyUpdate current = propertyUpdates;
        while (current != null) {
            switch (current.mode) {
                case ADDED: {
                    this.propertiesAfter.put(current.propertyKeyId, current.value);
                    break;
                }
                case REMOVED: {
                    this.propertiesBefore.put(current.propertyKeyId, current.value);
                    break;
                }
                case CHANGED: {
                    this.propertiesBefore.put(current.propertyKeyId, ((PropertyChanged)current).before);
                    this.propertiesAfter.put(current.propertyKeyId, current.value);
                    break;
                }
                default: {
                    throw new IllegalStateException(current.mode.toString());
                }
            }
            current = current.next;
        }
        for (DefinedProperty property : definedProperties) {
            if (this.propertiesAfter.containsKey(property.propertyKeyId()) || this.propertiesBefore.containsKey(property.propertyKeyId())) continue;
            this.propertiesUnchanged.put(property.propertyKeyId(), property.value());
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append("[").append(this.nodeId);
        result.append(", labelsBefore:").append(Arrays.toString(this.labelsBefore));
        result.append(", labelsAfter:").append(Arrays.toString(this.labelsAfter));
        this.printProperties(result, "Before", this.propertiesBefore);
        this.printProperties(result, "After", this.propertiesAfter);
        this.printProperties(result, "Unchanged", this.propertiesUnchanged);
        return result.append("]").toString();
    }

    private void printProperties(StringBuilder result, String suffix, Map<Integer, Object> properties) {
        for (Map.Entry<Integer, Object> entry : properties.entrySet()) {
            result.append(", Property" + suffix + "[" + entry.getKey() + "]: " + entry.getValue());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.labelsBefore);
        result = 31 * result + Arrays.hashCode(this.labelsAfter);
        result = 31 * result + (int)(this.nodeId ^ this.nodeId >>> 32);
        result = this.addPropertiesTohash(31, result, this.propertiesBefore);
        result = this.addPropertiesTohash(31, result, this.propertiesAfter);
        return result;
    }

    private int addPropertiesTohash(int prime, int result, Map<Integer, Object> properties) {
        for (int propertyKeyId : properties.keySet()) {
            result = prime * result + propertyKeyId;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeUpdates other = (NodeUpdates)obj;
        return Arrays.equals(this.labelsBefore, other.labelsBefore) && Arrays.equals(this.labelsAfter, other.labelsAfter) && this.nodeId == other.nodeId && this.propertyMapEquals(this.propertiesBefore, other.propertiesBefore) && this.propertyMapEquals(this.propertiesAfter, other.propertiesAfter) && this.propertyMapEquals(this.propertiesUnchanged, other.propertiesUnchanged);
    }

    private boolean propertyMapEquals(Map<Integer, Object> a, Map<Integer, Object> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Map.Entry<Integer, Object> entry : a.entrySet()) {
            int key = entry.getKey();
            if (b.containsKey(key) && NodeUpdates.propertyValueEqual(b.get(key), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean hasIndexingAppropriateUpdates() {
        boolean propertiesExistOrAdded = !this.propertiesAfter.isEmpty() || !this.propertiesUnchanged.isEmpty();
        boolean propertiesExistOrRemoved = !this.propertiesBefore.isEmpty() || !this.propertiesUnchanged.isEmpty();
        boolean labelsExistOrAdded = this.labelChangeSummary.hasAddedLabels() || this.labelChangeSummary.hasUnchangedLabels();
        boolean labelsExistOrRemoved = this.labelChangeSummary.hasRemovedLabels() || this.labelChangeSummary.hasUnchangedLabels();
        boolean hasLabelsAdded = this.labelChangeSummary.hasAddedLabels() && propertiesExistOrAdded;
        boolean hasLabelsRemoved = this.labelChangeSummary.hasRemovedLabels() && propertiesExistOrRemoved;
        boolean hasPropertiesAdded = !this.propertiesAfter.isEmpty() && labelsExistOrAdded;
        boolean hasPropertiesRemoved = !this.propertiesBefore.isEmpty() && labelsExistOrRemoved;
        return hasLabelsAdded || hasLabelsRemoved || hasPropertiesAdded || hasPropertiesRemoved;
    }

    private static boolean propertyValueEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof boolean[] && b instanceof boolean[]) {
            return Arrays.equals((boolean[])a, (boolean[])b);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        if (a instanceof short[] && b instanceof short[]) {
            return Arrays.equals((short[])a, (short[])b);
        }
        if (a instanceof int[] && b instanceof int[]) {
            return Arrays.equals((int[])a, (int[])b);
        }
        if (a instanceof long[] && b instanceof long[]) {
            return Arrays.equals((long[])a, (long[])b);
        }
        if (a instanceof char[] && b instanceof char[]) {
            return Arrays.equals((char[])a, (char[])b);
        }
        if (a instanceof float[] && b instanceof float[]) {
            return Arrays.equals((float[])a, (float[])b);
        }
        if (a instanceof double[] && b instanceof double[]) {
            return Arrays.equals((double[])a, (double[])b);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return Arrays.equals((Object[])a, (Object[])b);
        }
        return a.equals(b);
    }

    public static class PropertyChanged
    extends PropertyUpdate {
        private final Object before;

        private PropertyChanged(int propertyKeyId, Object before, Object after) {
            super(propertyKeyId, after, UpdateMode.CHANGED);
            this.before = before;
        }

        public Object before() {
            return this.before;
        }
    }

    private static class PropertyRemoved
    extends PropertyUpdate {
        private PropertyRemoved(int propertyKeyId, Object value) {
            super(propertyKeyId, value, UpdateMode.REMOVED);
        }
    }

    private static class PropertyAdded
    extends PropertyUpdate {
        private PropertyAdded(int propertyKeyId, Object value) {
            super(propertyKeyId, value, UpdateMode.ADDED);
        }
    }

    private static abstract class PropertyUpdate {
        private final int propertyKeyId;
        private final Object value;
        private final UpdateMode mode;
        private PropertyUpdate next;

        private PropertyUpdate(int propertyKeyId, Object value, UpdateMode mode) {
            this.propertyKeyId = propertyKeyId;
            this.value = value;
            this.mode = mode;
        }

        public UpdateMode mode() {
            return this.mode;
        }

        public int propertyKeyId() {
            return this.propertyKeyId;
        }

        public Object value() {
            return this.value;
        }
    }

    public static class Builder {
        private PropertyUpdate propertyUpdates;
        private NodeUpdates updates;

        private Builder(NodeUpdates updates) {
            this.updates = updates;
        }

        private void addUpdate(PropertyUpdate update) {
            update.next = this.propertyUpdates;
            this.propertyUpdates = update;
        }

        public Builder added(int propertyKeyId, Object value) {
            this.addUpdate(new PropertyAdded(propertyKeyId, value));
            return this;
        }

        public Builder removed(int propertyKeyId, Object value) {
            this.addUpdate(new PropertyRemoved(propertyKeyId, value));
            return this;
        }

        public Builder changed(int propertyKeyId, Object before, Object after) {
            this.addUpdate(new PropertyChanged(propertyKeyId, before, after));
            return this;
        }

        public NodeUpdates build() {
            this.updates.setProperties(this.propertyUpdates, new DefinedProperty[0]);
            return this.updates;
        }

        public NodeUpdates buildWithExistingProperties(DefinedProperty ... definedProperties) {
            this.updates.setProperties(this.propertyUpdates, definedProperties);
            return this.updates;
        }

        public boolean hasUpdatedLabels() {
            return this.updates.labelChangeSummary.hasAddedLabels() || this.updates.labelChangeSummary.hasRemovedLabels();
        }

        public boolean hasUpdates() {
            return this.propertyUpdates != null || this.updates.hasIndexingAppropriateUpdates();
        }
    }
}

