/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;

public class AlreadyIndexedException
extends SchemaKernelException {
    private static final String NO_CONTEXT_FORMAT = "Already indexed %s.";
    private static final String INDEX_CONTEXT_FORMAT = "There already exists an index for label '%s' on property '%s'.";
    private static final String CONSTRAINT_CONTEXT_FORMAT = "There already exists an index for label '%s' on property '%s'. A constraint cannot be created until the index has been dropped.";
    private final NodePropertyDescriptor descriptor;
    private final SchemaKernelException.OperationContext context;

    public AlreadyIndexedException(NodePropertyDescriptor descriptor, SchemaKernelException.OperationContext context) {
        super((Status)Status.Schema.IndexAlreadyExists, AlreadyIndexedException.constructUserMessage(context, null, descriptor));
        this.descriptor = descriptor;
        this.context = context;
    }

    private static String constructUserMessage(SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup, NodePropertyDescriptor descriptor) {
        switch (context) {
            case INDEX_CREATION: {
                return AlreadyIndexedException.messageWithLabelAndPropertyName(tokenNameLookup, INDEX_CONTEXT_FORMAT, descriptor);
            }
            case CONSTRAINT_CREATION: {
                return AlreadyIndexedException.messageWithLabelAndPropertyName(tokenNameLookup, CONSTRAINT_CONTEXT_FORMAT, descriptor);
            }
        }
        return String.format(NO_CONTEXT_FORMAT, descriptor);
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return AlreadyIndexedException.constructUserMessage(this.context, tokenNameLookup, this.descriptor);
    }
}

