/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.constraints;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.IndexDescriptorFactory;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;

public class UniquenessConstraint
extends NodePropertyConstraint {
    public UniquenessConstraint(NodePropertyDescriptor descriptor) {
        super(descriptor);
    }

    public IndexDescriptor indexDescriptor() {
        return IndexDescriptorFactory.of(this.descriptor);
    }

    @Override
    public void added(PropertyConstraint.ChangeVisitor visitor) {
        visitor.visitAddedUniquePropertyConstraint(this);
    }

    @Override
    public void removed(PropertyConstraint.ChangeVisitor visitor) {
        visitor.visitRemovedUniquePropertyConstraint(this);
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        String labelName = this.labelName(tokenNameLookup);
        String boundIdentifier = labelName.toLowerCase();
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT %s.%s IS UNIQUE", boundIdentifier, labelName, boundIdentifier, this.descriptor.propertyNameText(tokenNameLookup));
    }

    @Override
    public String toString() {
        return String.format("CONSTRAINT ON ( n:label[%s] ) ASSERT n.property[%s] IS UNIQUE", this.descriptor.getLabelId(), this.descriptor.propertyIdText());
    }
}

