/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema_new.SchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaDescriptorPredicates;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaStorage
implements SchemaRuleAccess {
    private final RecordStore<DynamicRecord> schemaStore;

    public SchemaStorage(RecordStore<DynamicRecord> schemaStore) {
        this.schemaStore = schemaStore;
    }

    public IndexRule indexGetForSchema(SchemaDescriptor schemaDescriptor) {
        return this.indexGetForSchema(schemaDescriptor, NewIndexDescriptor.Filter.ANY);
    }

    public IndexRule indexGetForSchema(SchemaDescriptor descriptor, NewIndexDescriptor.Filter filter) {
        Iterator<IndexRule> rules = this.loadAllSchemaRules(SchemaDescriptor.equalTo(descriptor), IndexRule.class, false);
        IndexRule foundRule = null;
        while (rules.hasNext()) {
            IndexRule candidate = rules.next();
            if (!filter.test(candidate.getIndexDescriptor())) continue;
            if (foundRule != null) {
                throw new IllegalStateException(String.format("Found more than one matching index rule, %s and %s", foundRule, candidate));
            }
            foundRule = candidate;
        }
        return foundRule;
    }

    public Iterator<IndexRule> indexesGetAll() {
        return this.loadAllSchemaRules(Predicates.alwaysTrue(), IndexRule.class, false);
    }

    public Iterator<ConstraintRule> constraintsGetAll() {
        return this.loadAllSchemaRules(Predicates.alwaysTrue(), ConstraintRule.class, false);
    }

    public Iterator<ConstraintRule> constraintsGetAllIgnoreMalformed() {
        return this.loadAllSchemaRules(Predicates.alwaysTrue(), ConstraintRule.class, true);
    }

    public Iterator<ConstraintRule> constraintsGetForRelType(int relTypeId) {
        return this.loadAllSchemaRules(rule -> SchemaDescriptorPredicates.hasRelType(rule, relTypeId), ConstraintRule.class, false);
    }

    public Iterator<ConstraintRule> constraintsGetForLabel(int labelId) {
        return this.loadAllSchemaRules(rule -> SchemaDescriptorPredicates.hasLabel(rule, labelId), ConstraintRule.class, false);
    }

    public Iterator<ConstraintRule> constraintsGetForSchema(SchemaDescriptor schemaDescriptor) {
        return this.loadAllSchemaRules(SchemaDescriptor.equalTo(schemaDescriptor), ConstraintRule.class, false);
    }

    public ConstraintRule constraintsGetSingle(ConstraintDescriptor descriptor) throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        Iterator<ConstraintRule> rules = this.loadAllSchemaRules(descriptor::isSame, ConstraintRule.class, false);
        if (!rules.hasNext()) {
            throw new SchemaRuleNotFoundException(SchemaRule.Kind.map(descriptor), descriptor.schema());
        }
        ConstraintRule rule = rules.next();
        if (rules.hasNext()) {
            throw new DuplicateSchemaRuleException(SchemaRule.Kind.map(descriptor), descriptor.schema());
        }
        return rule;
    }

    public Iterator<SchemaRule> loadAllSchemaRules() {
        return this.loadAllSchemaRules(Predicates.alwaysTrue(), SchemaRule.class, false);
    }

    @Override
    public SchemaRule loadSingleSchemaRule(long ruleId) throws MalformedSchemaRuleException {
        return this.loadSingleSchemaRuleViaBuffer(ruleId, this.newRecordBuffer());
    }

    <ReturnType extends SchemaRule> Iterator<ReturnType> loadAllSchemaRules(final Predicate<ReturnType> predicate, final Class<ReturnType> returnType, final boolean ignoreMalformed) {
        return new PrefetchingIterator<ReturnType>(){
            private final long highestId;
            private long currentId;
            private final byte[] scratchData;
            private final DynamicRecord record;
            {
                this.highestId = SchemaStorage.this.schemaStore.getHighestPossibleIdInUse();
                this.currentId = 1L;
                this.scratchData = SchemaStorage.this.newRecordBuffer();
                this.record = (DynamicRecord)SchemaStorage.this.schemaStore.newRecord();
            }

            protected ReturnType fetchNextOrNull() {
                while (this.currentId <= this.highestId) {
                    long id;
                    ++this.currentId;
                    SchemaStorage.this.schemaStore.getRecord(id, this.record, RecordLoad.FORCE);
                    if (!this.record.inUse() || !this.record.isStartRecord()) continue;
                    try {
                        SchemaRule returnRule;
                        SchemaRule schemaRule = SchemaStorage.this.loadSingleSchemaRuleViaBuffer(id, this.scratchData);
                        if (!returnType.isInstance(schemaRule) || !predicate.test(returnRule = (SchemaRule)returnType.cast(schemaRule))) continue;
                        return returnRule;
                    }
                    catch (MalformedSchemaRuleException e) {
                        if (ignoreMalformed) continue;
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
    }

    private SchemaRule loadSingleSchemaRuleViaBuffer(long id, byte[] buffer) throws MalformedSchemaRuleException {
        Collection<DynamicRecord> records;
        try {
            records = this.schemaStore.getRecords(id, RecordLoad.NORMAL);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException(e.getMessage(), e);
        }
        return SchemaStore.readSchemaRule(id, records, buffer);
    }

    public long newRuleId() {
        return this.schemaStore.nextId();
    }

    private byte[] newRecordBuffer() {
        return new byte[this.schemaStore.getRecordSize() * 4];
    }
}

