/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Collections;
import java.util.Set;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;

public class MultipleUnderlyingStorageExceptions
extends UnderlyingStorageException {
    public final Set<Pair<NewIndexDescriptor, UnderlyingStorageException>> exceptions;

    public MultipleUnderlyingStorageExceptions(Set<Pair<NewIndexDescriptor, UnderlyingStorageException>> exceptions) {
        super(MultipleUnderlyingStorageExceptions.buildMessage(exceptions));
        this.exceptions = Collections.unmodifiableSet(exceptions);
        for (Pair<NewIndexDescriptor, UnderlyingStorageException> exception : exceptions) {
            this.addSuppressed((Throwable)exception.other());
        }
    }

    private static String buildMessage(Set<Pair<NewIndexDescriptor, UnderlyingStorageException>> exceptions) {
        StringBuilder builder = new StringBuilder();
        builder.append("Errors when closing (flushing) index updaters:");
        for (Pair<NewIndexDescriptor, UnderlyingStorageException> pair : exceptions) {
            builder.append(String.format(" (%s) %s", ((NewIndexDescriptor)pair.first()).toString(), ((UnderlyingStorageException)pair.other()).getMessage()));
        }
        return builder.toString();
    }
}

