/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.ProcedureInjectionException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserAggregationFunction;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.FieldSignature;
import org.neo4j.kernel.api.proc.LoadFailProcedure;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.FieldInjections;
import org.neo4j.kernel.impl.proc.MethodSignatureCompiler;
import org.neo4j.kernel.impl.proc.OutputMappers;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;
import org.neo4j.procedure.UserFunction;

class ReflectiveProcedureCompiler {
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final OutputMappers outputMappers;
    private final MethodSignatureCompiler inputSignatureDeterminer;
    private final FieldInjections safeFieldInjections;
    private final FieldInjections allFieldInjections;
    private final Log log;
    private final TypeMappers typeMappers;
    private final ProcedureConfig config;

    ReflectiveProcedureCompiler(TypeMappers typeMappers, ComponentRegistry safeComponents, ComponentRegistry allComponents, Log log, ProcedureConfig config) {
        this.inputSignatureDeterminer = new MethodSignatureCompiler(typeMappers);
        this.outputMappers = new OutputMappers(typeMappers);
        this.safeFieldInjections = new FieldInjections(safeComponents);
        this.allFieldInjections = new FieldInjections(allComponents);
        this.log = log;
        this.typeMappers = typeMappers;
        this.config = config;
    }

    List<CallableUserFunction> compileFunction(Class<?> fcnDefinition) throws KernelException {
        try {
            List procedureMethods = Arrays.stream(fcnDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(UserFunction.class)).collect(Collectors.toList());
            if (procedureMethods.isEmpty()) {
                return Collections.emptyList();
            }
            MethodHandle constructor = this.constructor(fcnDefinition);
            ArrayList<CallableUserFunction> out = new ArrayList<CallableUserFunction>(procedureMethods.size());
            for (Method method : procedureMethods) {
                out.add(this.compileFunction(fcnDefinition, constructor, method));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile function defined in `%s`: %s", fcnDefinition.getSimpleName(), e.getMessage());
        }
    }

    List<CallableUserAggregationFunction> compileAggregationFunction(Class<?> fcnDefinition) throws KernelException {
        try {
            List methods = Arrays.stream(fcnDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(UserAggregationFunction.class)).collect(Collectors.toList());
            if (methods.isEmpty()) {
                return Collections.emptyList();
            }
            MethodHandle constructor = this.constructor(fcnDefinition);
            ArrayList<CallableUserAggregationFunction> out = new ArrayList<CallableUserAggregationFunction>(methods.size());
            for (Method method : methods) {
                out.add(this.compileAggregationFunction(fcnDefinition, constructor, method));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile function defined in `%s`: %s", fcnDefinition.getSimpleName(), e.getMessage());
        }
    }

    List<CallableProcedure> compileProcedure(Class<?> procDefinition, Optional<String> warning, boolean fullAccess) throws KernelException {
        try {
            List procedureMethods = Arrays.stream(procDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(Procedure.class)).collect(Collectors.toList());
            if (procedureMethods.isEmpty()) {
                return Collections.emptyList();
            }
            MethodHandle constructor = this.constructor(procDefinition);
            ArrayList<CallableProcedure> out = new ArrayList<CallableProcedure>(procedureMethods.size());
            for (Method method : procedureMethods) {
                out.add(this.compileProcedure(procDefinition, constructor, method, warning, fullAccess));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile procedure defined in `%s`: %s", procDefinition.getSimpleName(), e.getMessage());
        }
    }

    private CallableProcedure compileProcedure(Class<?> procDefinition, MethodHandle constructor, Method method, Optional<String> warning, boolean fullAccess) throws ProcedureException, IllegalAccessException {
        MethodHandle procedureMethod = this.lookup.unreflect(method);
        String valueName = method.getAnnotation(Procedure.class).value();
        String definedName = method.getAnnotation(Procedure.class).name();
        QualifiedName procName = this.extractName(procDefinition, method, valueName, definedName);
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(method);
        OutputMappers.OutputMapper outputMapper = this.outputMappers.mapper(method);
        Optional<String> description = this.description(method);
        Procedure procedure = method.getAnnotation(Procedure.class);
        Mode mode = procedure.mode();
        if (method.isAnnotationPresent(PerformsWrites.class)) {
            if (!procedure.mode().equals((Object)Mode.DEFAULT)) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Conflicting procedure annotation, cannot use PerformsWrites and mode", new Object[0]);
            }
            mode = Mode.WRITE;
        }
        Optional<String> deprecated = this.deprecated(method, procedure::deprecatedBy, "Use of @Procedure(deprecatedBy) without @Deprecated in " + procName);
        List<FieldInjections.FieldSetter> setters = this.allFieldInjections.setters(procDefinition);
        if (!fullAccess && !this.config.fullAccessFor(procName.toString())) {
            try {
                setters = this.safeFieldInjections.setters(procDefinition);
            }
            catch (ProcedureInjectionException e) {
                description = Optional.of(procName.toString() + " is not available due to not having unrestricted access rights, check configuration.");
                this.log.warn(description.get());
                ProcedureSignature signature = new ProcedureSignature(procName, inputSignature, outputMapper.signature(), Mode.DEFAULT, Optional.empty(), new String[0], description, warning);
                return new LoadFailProcedure(signature);
            }
        }
        ProcedureSignature signature = new ProcedureSignature(procName, inputSignature, outputMapper.signature(), mode, deprecated, this.config.rolesFor(procName.toString()), description, warning);
        return new ReflectiveProcedure(signature, constructor, procedureMethod, outputMapper, setters);
    }

    private ReflectiveUserFunction compileFunction(Class<?> procDefinition, MethodHandle constructor, Method method) throws ProcedureException, IllegalAccessException {
        String definedName;
        String valueName = method.getAnnotation(UserFunction.class).value();
        QualifiedName procName = this.extractName(procDefinition, method, valueName, definedName = method.getAnnotation(UserFunction.class).name());
        if (procName.namespace() == null || procName.namespace().length == 0) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "It is not allowed to define functions in the root namespace please use a namespace, e.g. `@UserFunction(\"org.example.com.%s\")", procName.name());
        }
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(method);
        Class<?> returnType = method.getReturnType();
        TypeMappers.NeoValueConverter valueConverter = this.typeMappers.converterFor(returnType);
        MethodHandle procedureMethod = this.lookup.unreflect(method);
        List<FieldInjections.FieldSetter> setters = this.safeFieldInjections.setters(procDefinition);
        Optional<String> description = this.description(method);
        UserFunction function = method.getAnnotation(UserFunction.class);
        Optional<String> deprecated = this.deprecated(method, function::deprecatedBy, "Use of @UserFunction(deprecatedBy) without @Deprecated in " + procName);
        UserFunctionSignature signature = new UserFunctionSignature(procName, inputSignature, valueConverter.type(), deprecated, this.config.rolesFor(procName.toString()), description);
        return new ReflectiveUserFunction(signature, constructor, procedureMethod, valueConverter, setters);
    }

    private ReflectiveUserAggregationFunction compileAggregationFunction(Class<?> definition, MethodHandle constructor, Method method) throws ProcedureException, IllegalAccessException {
        String definedName;
        String valueName = method.getAnnotation(UserAggregationFunction.class).value();
        QualifiedName funcName = this.extractName(definition, method, valueName, definedName = method.getAnnotation(UserAggregationFunction.class).name());
        if (funcName.namespace() == null || funcName.namespace().length == 0) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "It is not allowed to define functions in the root namespace please use a namespace, e.g. `@UserFunction(\"org.example.com.%s\")", funcName.name());
        }
        Method update = null;
        Method result = null;
        Class<?> aggregator = method.getReturnType();
        for (Method m : aggregator.getDeclaredMethods()) {
            if (m.isAnnotationPresent(UserAggregationUpdate.class)) {
                if (update != null) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Class '%s' contains multiple methods annotated with '@%s'.", aggregator.getSimpleName(), UserAggregationUpdate.class.getSimpleName());
                }
                update = m;
            }
            if (!m.isAnnotationPresent(UserAggregationResult.class)) continue;
            if (result != null) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Class '%s' contains multiple methods annotated with '@%s'.", aggregator.getSimpleName(), UserAggregationResult.class.getSimpleName());
            }
            result = m;
        }
        if (result == null || update == null) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Class '%s' must contain methods annotated with both '@%s' as well as '@%s'.", aggregator.getSimpleName(), UserAggregationResult.class.getSimpleName(), UserAggregationUpdate.class.getSimpleName());
        }
        if (update.getReturnType() != Void.TYPE) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Update method '%s' in %s has type '%s' but must have return type 'void'.", update.getName(), aggregator.getSimpleName(), update.getReturnType().getSimpleName());
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation method '%s' in %s must be public.", method.getName(), definition.getSimpleName());
        }
        if (!Modifier.isPublic(aggregator.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation class '%s' must be public.", aggregator.getSimpleName());
        }
        if (!Modifier.isPublic(update.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation update method '%s' in %s must be public.", method.getName(), aggregator.getSimpleName());
        }
        if (!Modifier.isPublic(result.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation result method '%s' in %s must be public.", method.getName(), aggregator.getSimpleName());
        }
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(update);
        Class<?> returnType = result.getReturnType();
        TypeMappers.NeoValueConverter valueConverter = this.typeMappers.converterFor(returnType);
        MethodHandle creator = this.lookup.unreflect(method);
        MethodHandle updateMethod = this.lookup.unreflect(update);
        MethodHandle resultMethod = this.lookup.unreflect(result);
        List<FieldInjections.FieldSetter> setters = this.safeFieldInjections.setters(definition);
        Optional<String> description = this.description(method);
        UserAggregationFunction function = method.getAnnotation(UserAggregationFunction.class);
        Optional<String> deprecated = this.deprecated(method, function::deprecatedBy, "Use of @UserAggregationFunction(deprecatedBy) without @Deprecated in " + funcName);
        UserFunctionSignature signature = new UserFunctionSignature(funcName, inputSignature, valueConverter.type(), deprecated, this.config.rolesFor(funcName.toString()), description);
        return new ReflectiveUserAggregationFunction(signature, constructor, creator, updateMethod, resultMethod, valueConverter, setters);
    }

    private Optional<String> deprecated(Method method, Supplier<String> supplier, String warning) {
        String deprecatedBy = supplier.get();
        Optional<String> deprecated = Optional.empty();
        if (method.isAnnotationPresent(Deprecated.class)) {
            deprecated = Optional.of(deprecatedBy);
        } else if (!deprecatedBy.isEmpty()) {
            this.log.warn(warning);
            deprecated = Optional.of(deprecatedBy);
        }
        return deprecated;
    }

    private Optional<String> description(Method method) {
        if (method.isAnnotationPresent(Description.class)) {
            return Optional.of(method.getAnnotation(Description.class).value());
        }
        return Optional.empty();
    }

    private MethodHandle constructor(Class<?> procDefinition) throws ProcedureException {
        try {
            return this.lookup.unreflectConstructor(procDefinition.getConstructor(new Class[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Unable to find a usable public no-argument constructor in the class `%s`. Please add a valid, public constructor, recompile the class and try again.", procDefinition.getSimpleName());
        }
    }

    private QualifiedName extractName(Class<?> procDefinition, Method m, String valueName, String definedName) {
        String procName;
        String string = procName = definedName.trim().isEmpty() ? valueName : definedName;
        if (procName.trim().length() > 0) {
            String[] split = procName.split("\\.");
            if (split.length == 1) {
                return new QualifiedName(new String[0], split[0]);
            }
            int lastElement = split.length - 1;
            return new QualifiedName(Arrays.copyOf(split, lastElement), split[lastElement]);
        }
        Package pkg = procDefinition.getPackage();
        String[] namespace = pkg == null ? new String[]{} : pkg.getName().split("\\.");
        String name = m.getName();
        return new QualifiedName(namespace, name);
    }

    private static class ReflectiveUserAggregationFunction
    extends ReflectiveBase
    implements CallableUserAggregationFunction {
        private final TypeMappers.NeoValueConverter valueConverter;
        private final UserFunctionSignature signature;
        private final MethodHandle constructor;
        private final MethodHandle creator;
        private final MethodHandle updateMethod;
        private final MethodHandle resultMethod;

        ReflectiveUserAggregationFunction(UserFunctionSignature signature, MethodHandle constructor, MethodHandle creator, MethodHandle updateMethod, MethodHandle resultMethod, TypeMappers.NeoValueConverter outputMapper, List<FieldInjections.FieldSetter> fieldSetters) {
            super(fieldSetters);
            this.constructor = constructor;
            this.creator = creator;
            this.updateMethod = updateMethod;
            this.resultMethod = resultMethod;
            this.signature = signature;
            this.valueConverter = outputMapper;
        }

        @Override
        public UserFunctionSignature signature() {
            return this.signature;
        }

        @Override
        public CallableUserAggregationFunction.Aggregator create(Context ctx) throws ProcedureException {
            try {
                Object cls = this.constructor.invoke();
                this.inject(ctx, cls);
                final Object aggregator = this.creator.invoke(cls);
                return new CallableUserAggregationFunction.Aggregator(){

                    @Override
                    public void update(Object[] input) throws ProcedureException {
                        try {
                            int numberOfDeclaredArguments = signature.inputSignature().size();
                            if (numberOfDeclaredArguments != input.length) {
                                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Function `%s` takes %d arguments but %d was provided.", signature.name(), numberOfDeclaredArguments, input.length);
                            }
                            Object[] args = this.args(numberOfDeclaredArguments, aggregator, input);
                            updateMethod.invokeWithArguments(args);
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof Status.HasStatus) {
                                throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
                            }
                            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke function `%s`: %s", signature.name(), "Caused by: " + throwable);
                        }
                    }

                    @Override
                    public Object result() throws ProcedureException {
                        try {
                            return valueConverter.toNeoValue(resultMethod.invoke(aggregator));
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof Status.HasStatus) {
                                throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
                            }
                            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke function `%s`: %s", signature.name(), "Caused by: " + throwable);
                        }
                    }
                };
            }
            catch (Throwable throwable) {
                if (throwable instanceof Status.HasStatus) {
                    throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
                }
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke function `%s`: %s", this.signature.name(), "Caused by: " + throwable);
            }
        }
    }

    private static class ReflectiveUserFunction
    extends ReflectiveBase
    implements CallableUserFunction {
        private final TypeMappers.NeoValueConverter valueConverter;
        private final UserFunctionSignature signature;
        private final MethodHandle constructor;
        private final MethodHandle udfMethod;

        ReflectiveUserFunction(UserFunctionSignature signature, MethodHandle constructor, MethodHandle procedureMethod, TypeMappers.NeoValueConverter outputMapper, List<FieldInjections.FieldSetter> fieldSetters) {
            super(fieldSetters);
            this.constructor = constructor;
            this.udfMethod = procedureMethod;
            this.signature = signature;
            this.valueConverter = outputMapper;
        }

        @Override
        public UserFunctionSignature signature() {
            return this.signature;
        }

        @Override
        public Object apply(Context ctx, Object[] input) throws ProcedureException {
            try {
                int numberOfDeclaredArguments = this.signature.inputSignature().size();
                if (numberOfDeclaredArguments != input.length) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Function `%s` takes %d arguments but %d was provided.", this.signature.name(), numberOfDeclaredArguments, input.length);
                }
                Object cls = this.constructor.invoke();
                this.inject(ctx, cls);
                Object[] args = this.args(numberOfDeclaredArguments, cls, input);
                Object rs = this.udfMethod.invokeWithArguments(args);
                return this.valueConverter.toNeoValue(rs);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Status.HasStatus) {
                    throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
                }
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke function `%s`: %s", this.signature.name(), "Caused by: " + throwable);
            }
        }
    }

    private static class ReflectiveProcedure
    extends ReflectiveBase
    implements CallableProcedure {
        private final ProcedureSignature signature;
        private final OutputMappers.OutputMapper outputMapper;
        private final MethodHandle constructor;
        private final MethodHandle procedureMethod;

        ReflectiveProcedure(ProcedureSignature signature, MethodHandle constructor, MethodHandle procedureMethod, OutputMappers.OutputMapper outputMapper, List<FieldInjections.FieldSetter> fieldSetters) {
            super(fieldSetters);
            this.constructor = constructor;
            this.procedureMethod = procedureMethod;
            this.signature = signature;
            this.outputMapper = outputMapper;
        }

        @Override
        public ProcedureSignature signature() {
            return this.signature;
        }

        @Override
        public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input) throws ProcedureException {
            try {
                int numberOfDeclaredArguments = this.signature.inputSignature().size();
                if (numberOfDeclaredArguments != input.length) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Procedure `%s` takes %d arguments but %d was provided.", this.signature.name(), numberOfDeclaredArguments, input.length);
                }
                Object cls = this.constructor.invoke();
                this.inject(ctx, cls);
                Object[] args = this.args(numberOfDeclaredArguments, cls, input);
                Object rs = this.procedureMethod.invokeWithArguments(args);
                if (rs == null) {
                    return Iterators.asRawIterator(Collections.emptyIterator());
                }
                return new MappingIterator(((Stream)rs).iterator());
            }
            catch (Throwable throwable) {
                if (throwable instanceof Status.HasStatus) {
                    throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
                }
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke procedure `%s`: %s", this.signature.name(), "Caused by: " + throwable);
            }
        }

        private class MappingIterator
        implements RawIterator<Object[], ProcedureException> {
            private final Iterator<?> out;

            MappingIterator(Iterator<?> out) {
                this.out = out;
            }

            public boolean hasNext() throws ProcedureException {
                try {
                    return this.out.hasNext();
                }
                catch (RuntimeException e) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, (Throwable)e, "Failed to call procedure `%s`: %s", ReflectiveProcedure.this.signature, e.getMessage());
                }
            }

            public Object[] next() throws ProcedureException {
                try {
                    Object record = this.out.next();
                    return ReflectiveProcedure.this.outputMapper.apply(record);
                }
                catch (RuntimeException e) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, (Throwable)e, "Failed to call procedure `%s`: %s", ReflectiveProcedure.this.signature, e.getMessage());
                }
            }
        }
    }

    private static abstract class ReflectiveBase {
        final List<FieldInjections.FieldSetter> fieldSetters;

        ReflectiveBase(List<FieldInjections.FieldSetter> fieldSetters) {
            this.fieldSetters = fieldSetters;
        }

        protected void inject(Context ctx, Object object) throws ProcedureException {
            for (FieldInjections.FieldSetter setter : this.fieldSetters) {
                setter.apply(ctx, object);
            }
        }

        protected Object[] args(int numberOfDeclaredArguments, Object cls, Object[] input) {
            Object[] args = new Object[numberOfDeclaredArguments + 1];
            args[0] = cls;
            System.arraycopy(input, 0, args, 1, numberOfDeclaredArguments);
            return args;
        }
    }
}

