/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.neo4j.cursor.RawCursor;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.FileHandle;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanLayout;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.NativeAllEntriesLabelScanReader;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanReader;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanWriter;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class NativeLabelScanStore
implements LabelScanStore {
    public static final String FILE_NAME = "neostore.labelscanstore.db";
    private final boolean readOnly;
    private final LabelScanStore.Monitor monitor;
    private final PageCache pageCache;
    private final File storeFile;
    private final FullStoreChangeStream fullStoreChangeStream;
    private final int pageSize;
    private GBPTree<LabelScanKey, LabelScanValue> index;
    private volatile boolean started;
    private boolean recoveryStarted;
    private boolean needsRebuild;
    private final NativeLabelScanWriter singleWriter;

    public NativeLabelScanStore(PageCache pageCache, File storeDir, FullStoreChangeStream fullStoreChangeStream, boolean readOnly, LabelScanStore.Monitor monitor) {
        this(pageCache, storeDir, fullStoreChangeStream, readOnly, monitor, 0);
    }

    NativeLabelScanStore(PageCache pageCache, File storeDir, FullStoreChangeStream fullStoreChangeStream, boolean readOnly, LabelScanStore.Monitor monitor, int pageSize) {
        this.pageCache = pageCache;
        this.pageSize = pageSize;
        this.fullStoreChangeStream = fullStoreChangeStream;
        this.storeFile = new File(storeDir, FILE_NAME);
        this.singleWriter = new NativeLabelScanWriter(1000);
        this.readOnly = readOnly;
        this.monitor = monitor;
    }

    @Override
    public LabelScanReader newReader() {
        return new NativeLabelScanReader(this.index);
    }

    @Override
    public LabelScanWriter newWriter() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create index writer in read only mode.");
        }
        try {
            if (!this.started && !this.recoveryStarted) {
                this.index.prepareForRecovery();
                this.recoveryStarted = true;
            }
            return this.writer();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void force(IOLimiter limiter) throws UnderlyingStorageException {
        try {
            this.index.checkpoint(limiter);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public AllEntriesLabelScanReader allNodeLabelRanges() {
        IntFunction<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> seekProvider = labelId -> {
            try {
                return this.index.seek((Object)new LabelScanKey().set(labelId, 0L), (Object)new LabelScanKey().set(labelId, Long.MAX_VALUE));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        int highestLabelId = -1;
        try (RawCursor cursor = this.index.seek((Object)new LabelScanKey().set(Integer.MAX_VALUE, Long.MAX_VALUE), (Object)new LabelScanKey().set(0, 0L));){
            if (cursor.next()) {
                highestLabelId = ((LabelScanKey)((Hit)cursor.get()).key()).labelId;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new NativeAllEntriesLabelScanReader(seekProvider, highestLabelId);
    }

    @Override
    public ResourceIterator<File> snapshotStoreFiles() throws IOException {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.storeFile));
    }

    @Override
    public void init() throws IOException {
        this.monitor.init();
        boolean storeExists = this.storeExists();
        try {
            boolean bl = this.needsRebuild = !storeExists;
            if (!storeExists) {
                this.monitor.noIndex();
            }
            this.instantiateTree();
        }
        catch (MetadataMismatchException e) {
            this.monitor.notValidIndex();
            this.drop();
            this.instantiateTree();
            this.needsRebuild = true;
        }
    }

    private boolean storeExists() throws IOException {
        try {
            this.storeFileHandle();
            return true;
        }
        catch (NoSuchFileException e) {
            return false;
        }
    }

    private FileHandle storeFileHandle() throws IOException {
        return (FileHandle)Iterables.single((Iterable)this.pageCache.streamFilesRecursive(this.storeFile).collect(Collectors.toList()));
    }

    private void instantiateTree() throws IOException {
        this.index = new GBPTree(this.pageCache, this.storeFile, (Layout)new LabelScanLayout(), this.pageSize, GBPTree.NO_MONITOR);
    }

    private void drop() throws IOException {
        this.storeFileHandle().delete();
    }

    @Override
    public void start() throws IOException {
        if (this.needsRebuild) {
            long numberOfNodes;
            this.monitor.rebuilding();
            try (NativeLabelScanWriter writer = this.writer();){
                numberOfNodes = this.fullStoreChangeStream.applyTo(writer);
            }
            this.monitor.rebuilt(numberOfNodes);
            this.needsRebuild = false;
        }
        this.started = true;
    }

    private NativeLabelScanWriter writer() throws IOException {
        return this.singleWriter.initialize((Writer<LabelScanKey, LabelScanValue>)this.index.writer());
    }

    @Override
    public boolean isEmpty() throws IOException {
        try (RawCursor cursor = this.index.seek((Object)new LabelScanKey(0, 0L), (Object)new LabelScanKey(Integer.MAX_VALUE, Long.MAX_VALUE));){
            boolean bl = !cursor.next();
            return bl;
        }
    }

    @Override
    public void stop() throws IOException {
    }

    @Override
    public void shutdown() throws IOException {
        this.index.close();
    }
}

