/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.EntityItemHelper;
import org.neo4j.kernel.impl.api.store.DegreeCounter;
import org.neo4j.kernel.impl.api.store.NodeExploringCursors;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;

public class StoreSingleNodeCursor
extends EntityItemHelper
implements Cursor<NodeItem>,
NodeItem {
    private final NodeLabelView labelView;
    private final NodeRecord nodeRecord;
    private final RelationshipStore relationshipStore;
    private final RecordStore<RelationshipGroupRecord> relationshipGroupStore;
    private final Consumer<StoreSingleNodeCursor> instanceCache;
    private final LockService lockService;
    private final RecordCursors recordCursors;
    private final NodeExploringCursors cursors;
    private long nodeId = -1L;

    StoreSingleNodeCursor(NodeRecord nodeRecord, NeoStores neoStores, Consumer<StoreSingleNodeCursor> instanceCache, RecordCursors recordCursors, LockService lockService) {
        this.nodeRecord = nodeRecord;
        this.recordCursors = recordCursors;
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.lockService = lockService;
        this.instanceCache = instanceCache;
        this.cursors = new NodeExploringCursors(recordCursors, lockService, this.relationshipStore, this.relationshipGroupStore);
        this.labelView = new NodeLabelView(recordCursors.label());
    }

    public StoreSingleNodeCursor init(long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public NodeItem get() {
        return this;
    }

    public boolean next() {
        if (this.nodeId != -1L) {
            try {
                boolean bl = this.recordCursors.node().next(this.nodeId, this.nodeRecord, RecordLoad.CHECK);
                return bl;
            }
            finally {
                this.nodeId = -1L;
            }
        }
        this.labelView.clear();
        return false;
    }

    public void close() {
        this.labelView.clear();
        this.instanceCache.accept(this);
    }

    @Override
    public long id() {
        return this.nodeRecord.getId();
    }

    @Override
    public PrimitiveIntSet labels() {
        return this.labelView.load(this.nodeRecord).get();
    }

    @Override
    public boolean hasLabel(int labelId) {
        return this.labelView.load(this.nodeRecord).hasLabel(labelId);
    }

    private Lock shortLivedReadLock() {
        Lock lock = this.lockService.acquireNodeLock(this.nodeRecord.getId(), LockService.LockType.READ_LOCK);
        if (this.lockService != LockService.NO_LOCK_SERVICE) {
            boolean success = false;
            try {
                if (!this.recordCursors.node().next(this.nodeRecord.getId(), this.nodeRecord, RecordLoad.CHECK)) {
                    this.nodeRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
                }
                success = true;
            }
            finally {
                if (!success) {
                    lock.release();
                }
            }
        }
        return lock;
    }

    @Override
    public Cursor<PropertyItem> properties() {
        return this.cursors.properties(this.nextProp(), this.shortLivedReadLock());
    }

    @Override
    public Cursor<PropertyItem> property(int propertyKeyId) {
        return this.cursors.property(this.nextProp(), propertyKeyId, this.shortLivedReadLock());
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction) {
        return this.cursors.relationships(this.isDense(), this.nextRel(), this.id(), direction);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction, int ... relTypes) {
        return this.cursors.relationships(this.isDense(), this.nextRel(), this.id(), direction, relTypes);
    }

    @Override
    public PrimitiveIntSet relationshipTypes() {
        PrimitiveIntSet set = Primitive.intSet();
        if (this.isDense()) {
            RelationshipGroupRecord groupRecord = this.relationshipGroupStore.newRecord();
            long id = this.nextGroupId();
            while (id != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                if (this.recordCursors.relationshipGroup().next(id, groupRecord, RecordLoad.FORCE)) {
                    set.add(groupRecord.getType());
                }
                id = groupRecord.getNext();
            }
        } else {
            this.relationships(Direction.BOTH).forAll(relationship -> set.add(relationship.type()));
        }
        return set;
    }

    @Override
    public int degree(Direction direction) {
        if (this.isDense()) {
            return DegreeCounter.countRelationshipsInGroup(this.nextGroupId(), direction, null, this.id(), (RelationshipRecord)this.relationshipStore.newRecord(), this.relationshipGroupStore.newRecord(), this.recordCursors);
        }
        return Cursors.count(this.relationships(direction));
    }

    @Override
    public int degree(Direction direction, int relType) {
        if (this.isDense()) {
            return DegreeCounter.countRelationshipsInGroup(this.nextGroupId(), direction, relType, this.id(), (RelationshipRecord)this.relationshipStore.newRecord(), this.relationshipGroupStore.newRecord(), this.recordCursors);
        }
        return Cursors.count(this.relationships(direction, relType));
    }

    @Override
    public boolean isDense() {
        return this.nodeRecord.isDense();
    }

    @Override
    public long nextGroupId() {
        assert (this.isDense());
        return this.nextRel();
    }

    private long nextRel() {
        return this.nodeRecord.getNextRel();
    }

    private long nextProp() {
        return this.nodeRecord.getNextProp();
    }

    private static class NodeLabelView
    implements Supplier<PrimitiveIntSet> {
        private final RecordCursor<DynamicRecord> dynamicLabelRecordCursor;
        private long[] labels;

        NodeLabelView(RecordCursor<DynamicRecord> dynamicLabelRecordCursor) {
            this.dynamicLabelRecordCursor = dynamicLabelRecordCursor;
        }

        NodeLabelView load(NodeRecord nodeRecord) {
            if (this.labels == null) {
                this.labels = NodeLabelsField.get(nodeRecord, this.dynamicLabelRecordCursor);
            }
            return this;
        }

        void clear() {
            this.labels = null;
        }

        boolean hasLabel(int labelId) {
            Objects.requireNonNull(this.labels);
            for (long label : this.labels) {
                if (IoPrimitiveUtils.safeCastLongToInt(label) != labelId) continue;
                return true;
            }
            return false;
        }

        @Override
        public PrimitiveIntSet get() {
            Objects.requireNonNull(this.labels);
            return PrimitiveIntCollections.asSet((long[])this.labels, IoPrimitiveUtils::safeCastLongToInt);
        }
    }
}

