/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.updater;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;

public abstract class UniquePropertyIndexUpdater
implements IndexUpdater {
    private final Map<Object, DiffSets<Long>> referenceCount = new HashMap<Object, DiffSets<Long>>();
    private final ArrayList<IndexEntryUpdate> updates = new ArrayList();

    @Override
    public void process(IndexEntryUpdate update) {
        switch (update.updateMode()) {
            case ADDED: {
                this.propertyValueDiffSet(update.values()).add((Object)update.getEntityId());
                break;
            }
            case CHANGED: {
                this.propertyValueDiffSet(update.beforeValues()).remove((Object)update.getEntityId());
                this.propertyValueDiffSet(update.values()).add((Object)update.getEntityId());
                break;
            }
            case REMOVED: {
                this.propertyValueDiffSet(update.values()).remove((Object)update.getEntityId());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.updates.add(update);
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        this.flushUpdates(this.updates);
    }

    protected abstract void flushUpdates(Iterable<IndexEntryUpdate> var1) throws IOException, IndexEntryConflictException;

    private DiffSets<Long> propertyValueDiffSet(Object value) {
        DiffSets<Long> diffSets = this.referenceCount.get(value);
        if (diffSets == null) {
            diffSets = new DiffSets();
            this.referenceCount.put(value, diffSets);
        }
        return diffSets;
    }
}

