/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodeUpdates;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.IndexBoundary;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.kernel.impl.api.index.MultiPopulatorFactory;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.RebuildingIndexDescriptor;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.transaction.state.DirectIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class IndexingService
extends LifecycleAdapter {
    private final IndexSamplingController samplingController;
    private final IndexProxyCreator indexProxyCreator;
    private final IndexStoreView storeView;
    private final SchemaIndexProviderMap providerMap;
    private final IndexMapReference indexMapRef;
    private final Iterable<IndexRule> indexRules;
    private final Log log;
    private final TokenNameLookup tokenNameLookup;
    private final MultiPopulatorFactory multiPopulatorFactory;
    private final LogProvider logProvider;
    private final Monitor monitor;
    private final PrimitiveLongSet recoveredNodeIds = Primitive.longSet((int)20);
    private final JobScheduler scheduler;
    private final Runnable schemaStateChangeCallback;
    public static final Monitor NO_MONITOR = new MonitorAdapter();
    private volatile State state = State.NOT_STARTED;

    IndexingService(IndexProxyCreator indexProxyCreator, SchemaIndexProviderMap providerMap, IndexMapReference indexMapRef, IndexStoreView storeView, Iterable<IndexRule> indexRules, IndexSamplingController samplingController, TokenNameLookup tokenNameLookup, JobScheduler scheduler, Runnable schemaStateChangeCallback, MultiPopulatorFactory multiPopulatorFactory, LogProvider logProvider, Monitor monitor) {
        this.indexProxyCreator = indexProxyCreator;
        this.providerMap = providerMap;
        this.indexMapRef = indexMapRef;
        this.storeView = storeView;
        this.indexRules = indexRules;
        this.samplingController = samplingController;
        this.tokenNameLookup = tokenNameLookup;
        this.scheduler = scheduler;
        this.schemaStateChangeCallback = schemaStateChangeCallback;
        this.multiPopulatorFactory = multiPopulatorFactory;
        this.logProvider = logProvider;
        this.monitor = monitor;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void init() {
        IndexMap indexMap = this.indexMapRef.indexMapSnapshot();
        for (IndexRule indexRule : this.indexRules) {
            IndexProxy indexProxy;
            long indexId = indexRule.getId();
            IndexDescriptor descriptor = IndexBoundary.map(indexRule.getIndexDescriptor());
            SchemaIndexProvider.Descriptor providerDescriptor = indexRule.getProviderDescriptor();
            SchemaIndexProvider provider = this.providerMap.apply(providerDescriptor);
            InternalIndexState initialState = provider.getInitialState(indexId);
            this.log.info(this.indexStateInfo("init", indexId, initialState, descriptor));
            boolean constraint = indexRule.canSupportUniqueConstraint();
            switch (initialState) {
                case ONLINE: {
                    indexProxy = this.indexProxyCreator.createOnlineIndexProxy(indexId, descriptor, providerDescriptor, constraint);
                    break;
                }
                case POPULATING: {
                    if (constraint && indexRule.getOwningConstraint() == null) {
                        indexProxy = this.indexProxyCreator.createFailedIndexProxy(indexId, descriptor, providerDescriptor, constraint, IndexPopulationFailure.failure("Constraint for index was not committed."));
                        break;
                    }
                    indexProxy = this.indexProxyCreator.createRecoveringIndexProxy(descriptor, providerDescriptor, constraint);
                    break;
                }
                case FAILED: {
                    IndexPopulationFailure failure = IndexPopulationFailure.failure(provider.getPopulationFailure(indexId));
                    indexProxy = this.indexProxyCreator.createFailedIndexProxy(indexId, descriptor, providerDescriptor, constraint, failure);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("" + (Object)((Object)initialState));
                }
            }
            indexMap.putIndexProxy(indexId, indexProxy);
        }
        this.indexMapRef.setIndexMap(indexMap);
    }

    public void start() throws Exception {
        this.state = State.STARTING;
        this.applyRecoveredUpdates();
        IndexMap indexMap = this.indexMapRef.indexMapSnapshot();
        HashMap rebuildingDescriptors = new HashMap();
        indexMap.foreachIndexProxy((indexId, proxy) -> {
            InternalIndexState state = proxy.getState();
            IndexDescriptor descriptor = proxy.getDescriptor();
            this.log.info(this.indexStateInfo("start", (Long)indexId, state, descriptor));
            switch (state) {
                case ONLINE: {
                    break;
                }
                case POPULATING: {
                    rebuildingDescriptors.put(indexId, new RebuildingIndexDescriptor(descriptor, proxy.getProviderDescriptor(), proxy.config()));
                    break;
                }
                case FAILED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + (Object)((Object)state));
                }
            }
        });
        this.dropRecoveringIndexes(indexMap, rebuildingDescriptors.keySet());
        if (!rebuildingDescriptors.isEmpty()) {
            IndexPopulationJob populationJob = this.newIndexPopulationJob();
            for (Map.Entry entry : rebuildingDescriptors.entrySet()) {
                long indexId2 = (Long)entry.getKey();
                RebuildingIndexDescriptor descriptor = (RebuildingIndexDescriptor)entry.getValue();
                IndexProxy proxy2 = this.indexProxyCreator.createPopulatingIndexProxy(indexId2, descriptor.getIndexDescriptor(), descriptor.getProviderDescriptor(), descriptor.getConfiguration(), false, this.monitor, populationJob);
                proxy2.start();
                indexMap.putIndexProxy(indexId2, proxy2);
            }
            this.startIndexPopulation(populationJob);
        }
        this.indexMapRef.setIndexMap(indexMap);
        this.samplingController.recoverIndexSamples();
        this.samplingController.start();
        for (Map.Entry entry : rebuildingDescriptors.entrySet()) {
            IndexProxy proxy3;
            if (!((RebuildingIndexDescriptor)entry.getValue()).getConfiguration().isUnique()) continue;
            try {
                proxy3 = this.getIndexProxy((Long)entry.getKey());
            }
            catch (IndexNotFoundKernelException e) {
                throw new IllegalStateException("What? This index was seen during recovery just now, why isn't it available now?");
            }
            this.monitor.awaitingPopulationOfRecoveredIndex((Long)entry.getKey(), ((RebuildingIndexDescriptor)entry.getValue()).getIndexDescriptor());
            this.awaitOnline(proxy3);
        }
        this.state = State.RUNNING;
    }

    private void awaitOnline(IndexProxy proxy) throws InterruptedException {
        block5: while (true) {
            switch (proxy.getState()) {
                case ONLINE: {
                    return;
                }
                case FAILED: {
                    throw new IllegalStateException("Index entered " + (Object)((Object)InternalIndexState.FAILED) + " state while recovery waited for it to be fully populated");
                }
                case POPULATING: {
                    Thread.sleep(10L);
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalStateException(proxy.getState().name());
    }

    public void shutdown() {
        this.state = State.STOPPED;
        this.samplingController.stop();
        this.closeAllIndexes();
    }

    public Register.DoubleLongRegister indexUpdatesAndSize(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        long indexId = this.indexMapRef.getOnlineIndexId(descriptor);
        Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
        this.storeView.indexUpdatesAndSize(indexId, output);
        return output;
    }

    public double indexUniqueValuesPercentage(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        long indexId = this.indexMapRef.getOnlineIndexId(descriptor);
        Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
        this.storeView.indexSample(indexId, output);
        long unique = output.readFirst();
        long size = output.readSecond();
        if (size == 0L) {
            return 1.0;
        }
        return (double)unique / (double)size;
    }

    public void apply(IndexUpdates updates) throws IOException, IndexEntryConflictException {
        if (this.state == State.NOT_STARTED) {
            updates.collectUpdatedNodeIds(this.recoveredNodeIds);
        } else if (this.state == State.RUNNING || this.state == State.STARTING) {
            this.apply(updates, IndexUpdateMode.ONLINE);
        } else {
            throw new IllegalStateException("Can't apply index updates " + Iterables.asList((Iterable)updates) + " while indexing service is " + (Object)((Object)this.state));
        }
    }

    private void apply(IndexUpdates updates, IndexUpdateMode updateMode) throws IOException, IndexEntryConflictException {
        try (IndexUpdaterMap updaterMap = this.indexMapRef.createIndexUpdaterMap(updateMode);){
            for (NodeUpdates update : updates) {
                for (IndexDescriptor descriptor : updaterMap.descriptors()) {
                    Optional<IndexEntryUpdate> entry = update.forIndex(IndexBoundary.map(descriptor));
                    if (!entry.isPresent()) continue;
                    updaterMap.getUpdater(descriptor).process(entry.get());
                }
            }
        }
    }

    public void createIndexes(IndexRule ... rules) throws IOException {
        IndexMap indexMap = this.indexMapRef.indexMapSnapshot();
        IndexPopulationJob populationJob = null;
        for (IndexRule rule : rules) {
            long ruleId = rule.getId();
            IndexProxy index = indexMap.getIndexProxy(ruleId);
            if (index != null && this.state == State.NOT_STARTED) {
                indexMap.putIndexProxy(ruleId, index);
                this.indexMapRef.setIndexMap(indexMap);
                continue;
            }
            IndexDescriptor descriptor = IndexBoundary.map(rule.getIndexDescriptor());
            SchemaIndexProvider.Descriptor providerDescriptor = rule.getProviderDescriptor();
            boolean constraint = rule.canSupportUniqueConstraint();
            if (this.state == State.RUNNING) {
                populationJob = populationJob == null ? this.newIndexPopulationJob() : populationJob;
                index = this.indexProxyCreator.createPopulatingIndexProxy(ruleId, descriptor, providerDescriptor, IndexConfiguration.of(constraint), constraint, this.monitor, populationJob);
                index.start();
            } else {
                index = this.indexProxyCreator.createRecoveringIndexProxy(descriptor, providerDescriptor, constraint);
            }
            indexMap.putIndexProxy(rule.getId(), index);
        }
        if (populationJob != null) {
            this.startIndexPopulation(populationJob);
        }
        this.indexMapRef.setIndexMap(indexMap);
    }

    private void applyRecoveredUpdates() throws IOException, IndexEntryConflictException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Applying recovered updates: " + this.recoveredNodeIds);
        }
        this.monitor.applyingRecoveredData(this.recoveredNodeIds);
        if (!this.recoveredNodeIds.isEmpty()) {
            try (IndexUpdaterMap updaterMap = this.indexMapRef.createIndexUpdaterMap(IndexUpdateMode.RECOVERY);){
                for (IndexUpdater updater : updaterMap) {
                    updater.remove(this.recoveredNodeIds);
                }
                IndexUpdates updates = this.readRecoveredUpdatesFromStore();
                this.apply(updates, IndexUpdateMode.RECOVERY);
                this.monitor.appliedRecoveredData(updates);
            }
        }
        this.recoveredNodeIds.clear();
    }

    private IndexUpdates readRecoveredUpdatesFromStore() {
        final ArrayList<NodeUpdates> recoveredUpdates = new ArrayList<NodeUpdates>();
        this.recoveredNodeIds.visitKeys((PrimitiveLongVisitor)new PrimitiveLongVisitor<RuntimeException>(){

            public boolean visited(long nodeId) {
                IndexingService.this.storeView.nodeAsUpdates(nodeId, recoveredUpdates);
                return false;
            }
        });
        return new DirectIndexUpdates(recoveredUpdates);
    }

    public void dropIndex(IndexRule rule) {
        long indexId = rule.getId();
        IndexProxy index = this.indexMapRef.removeIndexProxy(indexId);
        if (this.state == State.RUNNING) {
            assert (index != null) : "Index " + rule + " doesn't exists";
            try {
                Future<Void> dropFuture = index.drop();
                this.awaitIndexFuture(dropFuture);
            }
            catch (Exception e) {
                throw Exceptions.launderedException((Throwable)e);
            }
        }
    }

    public void triggerIndexSampling(IndexSamplingMode mode) {
        this.log.info("Manual trigger for sampling all indexes [" + (Object)((Object)mode) + "]");
        this.samplingController.sampleIndexes(mode);
    }

    public void triggerIndexSampling(IndexDescriptor descriptor, IndexSamplingMode mode) throws IndexNotFoundKernelException {
        String description = descriptor.userDescription(this.tokenNameLookup);
        this.log.info("Manual trigger for sampling index " + description + " [" + (Object)((Object)mode) + "]");
        this.samplingController.sampleIndex(this.indexMapRef.getIndexId(descriptor), mode);
    }

    private void awaitIndexFuture(Future<Void> future) throws Exception {
        try {
            future.get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw e;
        }
    }

    private void dropRecoveringIndexes(IndexMap indexMap, Iterable<Long> indexesToRebuild) throws IOException {
        for (long indexId : indexesToRebuild) {
            IndexProxy indexProxy = indexMap.removeIndexProxy(indexId);
            indexProxy.drop();
        }
    }

    public void activateIndex(long indexId) throws IndexNotFoundKernelException, IndexActivationFailedKernelException, IndexPopulationFailedKernelException {
        try {
            if (this.state == State.RUNNING) {
                IndexProxy index = this.getIndexProxy(indexId);
                index.awaitStoreScanCompleted();
                index.activate();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IndexActivationFailedKernelException(e, "Unable to activate index, thread was interrupted.");
        }
    }

    public IndexProxy getIndexProxy(long indexId) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(indexId);
    }

    public IndexProxy getIndexProxy(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(descriptor);
    }

    public long getIndexId(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexId(descriptor);
    }

    public void validateIndex(long indexId) throws IndexNotFoundKernelException, ConstraintVerificationFailedKernelException, IndexPopulationFailedKernelException {
        this.getIndexProxy(indexId).validate();
    }

    public void forceAll() {
        for (IndexProxy index : this.indexMapRef.getAllIndexProxies()) {
            try {
                index.force();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to force " + index, e);
            }
        }
    }

    public void flushAll() {
        for (IndexProxy index : this.indexMapRef.getAllIndexProxies()) {
            try {
                index.flush();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to force " + index, e);
            }
        }
    }

    private void closeAllIndexes() {
        Iterable<IndexProxy> indexesToStop = this.indexMapRef.clear();
        ArrayList<Future<Void>> indexStopFutures = new ArrayList<Future<Void>>();
        for (IndexProxy indexProxy : indexesToStop) {
            try {
                indexStopFutures.add(indexProxy.close());
            }
            catch (IOException e) {
                this.log.error("Unable to close index", (Throwable)e);
            }
        }
        for (Future future : indexStopFutures) {
            try {
                this.awaitIndexFuture(future);
            }
            catch (Exception e) {
                this.log.error("Error awaiting index to close", (Throwable)e);
            }
        }
    }

    public ResourceIterator<File> snapshotStoreFiles() throws IOException {
        ArrayList<ResourceIterator<File>> snapshots = new ArrayList<ResourceIterator<File>>();
        HashSet<SchemaIndexProvider.Descriptor> fromProviders = new HashSet<SchemaIndexProvider.Descriptor>();
        for (IndexProxy indexProxy : this.indexMapRef.getAllIndexProxies()) {
            SchemaIndexProvider.Descriptor providerDescriptor = indexProxy.getProviderDescriptor();
            if (fromProviders.add(providerDescriptor)) {
                snapshots.add(this.providerMap.apply(providerDescriptor).snapshotMetaFiles());
            }
            snapshots.add(indexProxy.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshots.iterator());
    }

    private IndexPopulationJob newIndexPopulationJob() {
        MultipleIndexPopulator multiPopulator = this.multiPopulatorFactory.create(this.storeView, this.logProvider);
        return new IndexPopulationJob(this.storeView, multiPopulator, this.monitor, this.schemaStateChangeCallback);
    }

    private void startIndexPopulation(IndexPopulationJob job) {
        this.scheduler.schedule(JobScheduler.Groups.indexPopulation, job);
    }

    private String indexStateInfo(String tag, Long indexId, InternalIndexState state, IndexDescriptor descriptor) {
        return String.format("IndexingService.%s: index %d on %s is %s", tag, indexId, descriptor.userDescription(this.tokenNameLookup), state.name());
    }

    public IndexSamplingController getSamplingController() {
        return this.samplingController;
    }

    public static class MonitorAdapter
    implements Monitor {
        @Override
        public void appliedRecoveredData(Iterable<NodeUpdates> updates) {
        }

        @Override
        public void applyingRecoveredData(PrimitiveLongSet recoveredNodeIds) {
        }

        @Override
        public void populationCompleteOn(IndexDescriptor descriptor) {
        }

        @Override
        public void verifyDeferredConstraints() {
        }

        @Override
        public void awaitingPopulationOfRecoveredIndex(long indexId, IndexDescriptor descriptor) {
        }
    }

    public static interface Monitor {
        public void applyingRecoveredData(PrimitiveLongSet var1);

        public void appliedRecoveredData(Iterable<NodeUpdates> var1);

        public void populationCompleteOn(IndexDescriptor var1);

        public void verifyDeferredConstraints();

        public void awaitingPopulationOfRecoveredIndex(long var1, IndexDescriptor var3);
    }

    static enum State {
        NOT_STARTED,
        STARTING,
        RUNNING,
        STOPPED;

    }
}

