/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;

public class GuardingStatementOperations
implements EntityWriteOperations,
EntityReadOperations {
    private final EntityWriteOperations entityWriteDelegate;
    private final EntityReadOperations entityReadDelegate;
    private final Guard guard;

    public GuardingStatementOperations(EntityWriteOperations entityWriteDelegate, EntityReadOperations entityReadDelegate, Guard guard) {
        this.entityWriteDelegate = entityWriteDelegate;
        this.entityReadDelegate = entityReadDelegate;
        this.guard = guard;
    }

    @Override
    public long relationshipCreate(KernelStatement statement, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        this.guard.check(statement);
        return this.entityWriteDelegate.relationshipCreate(statement, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeCreate(statement);
    }

    @Override
    public void nodeDelete(KernelStatement statement, long nodeId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        this.entityWriteDelegate.nodeDelete(statement, nodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement statement, long relationshipId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        this.entityWriteDelegate.relationshipDelete(statement, relationshipId);
    }

    @Override
    public int nodeDetachDelete(KernelStatement statement, long nodeId) throws KernelException {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeDetachDelete(statement, nodeId);
    }

    @Override
    public boolean nodeAddLabel(KernelStatement statement, long nodeId, int labelId) throws ConstraintValidationKernelException, EntityNotFoundException {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeAddLabel(statement, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement statement, long nodeId, int labelId) throws EntityNotFoundException {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeRemoveLabel(statement, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(KernelStatement statement, long nodeId, DefinedProperty property) throws ConstraintValidationKernelException, EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeSetProperty(statement, nodeId, property);
    }

    @Override
    public Property relationshipSetProperty(KernelStatement statement, long relationshipId, DefinedProperty property) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        return this.entityWriteDelegate.relationshipSetProperty(statement, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(KernelStatement statement, DefinedProperty property) {
        this.guard.check(statement);
        return this.entityWriteDelegate.graphSetProperty(statement, property);
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement statement, long nodeId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeRemoveProperty(statement, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement statement, long relationshipId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        return this.entityWriteDelegate.relationshipRemoveProperty(statement, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(KernelStatement statement, int propertyKeyId) {
        this.guard.check(statement);
        return this.entityWriteDelegate.graphRemoveProperty(statement, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement statement, int labelId) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetForLabel(statement, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexSeek(KernelStatement statement, NewIndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetFromIndexSeek(statement, index, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByNumber(KernelStatement statement, NewIndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper) throws IndexNotFoundKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetFromIndexRangeSeekByNumber(statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByString(KernelStatement statement, NewIndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetFromIndexRangeSeekByString(statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByPrefix(KernelStatement statement, NewIndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetFromIndexRangeSeekByPrefix(statement, index, prefix);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexScan(KernelStatement statement, NewIndexDescriptor index) throws IndexNotFoundKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetFromIndexScan(statement, index);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexContainsScan(KernelStatement statement, NewIndexDescriptor index, String term) throws IndexNotFoundKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetFromIndexContainsScan(statement, index, term);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexEndsWithScan(KernelStatement statement, NewIndexDescriptor index, String suffix) throws IndexNotFoundKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetFromIndexEndsWithScan(statement, index, suffix);
    }

    @Override
    public long nodeGetFromUniqueIndexSeek(KernelStatement statement, NewIndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeGetFromUniqueIndexSeek(statement, index, value);
    }

    @Override
    public long nodesCountIndexed(KernelStatement statement, NewIndexDescriptor index, long nodeId, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesCountIndexed(statement, index, nodeId, value);
    }

    @Override
    public boolean graphHasProperty(KernelStatement statement, int propertyKeyId) {
        this.guard.check(statement);
        return this.entityReadDelegate.graphHasProperty(statement, propertyKeyId);
    }

    @Override
    public Object graphGetProperty(KernelStatement statement, int propertyKeyId) {
        this.guard.check(statement);
        return this.entityReadDelegate.graphGetProperty(statement, propertyKeyId);
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.graphGetPropertyKeys(statement);
    }

    @Override
    public PrimitiveLongIterator nodesGetAll(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetAll(statement);
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipsGetAll(statement);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(KernelStatement statement, long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        this.guard.check(statement);
        this.entityReadDelegate.relationshipVisit(statement, relId, visitor);
    }

    @Override
    public Cursor<NodeItem> nodeCursorById(KernelStatement statement, long nodeId) throws EntityNotFoundException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeCursorById(statement, nodeId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorById(KernelStatement statement, long relId) throws EntityNotFoundException {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipCursorById(statement, relId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorGetAll(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipCursorGetAll(statement);
    }

    @Override
    public long nodesGetCount(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetCount(statement);
    }

    @Override
    public long relationshipsGetCount(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipsGetCount(statement);
    }

    @Override
    public boolean nodeExists(KernelStatement statement, long id) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeExists(statement, id);
    }
}

