/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.Strings;
import org.neo4j.helpers.collection.CastingIterator;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintKernelException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyConstraintViolationKernelException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.api.schema.RelationshipPropertyDescriptor;
import org.neo4j.kernel.api.schema_new.index.IndexBoundary;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.store.EntityLoadingIterator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;

public class ConstraintEnforcingEntityOperations
implements EntityOperations,
SchemaWriteOperations {
    private final EntityWriteOperations entityWriteOperations;
    private final EntityReadOperations entityReadOperations;
    private final SchemaWriteOperations schemaWriteOperations;
    private final SchemaReadOperations schemaReadOperations;
    private final ConstraintSemantics constraintSemantics;

    public ConstraintEnforcingEntityOperations(ConstraintSemantics constraintSemantics, EntityWriteOperations entityWriteOperations, EntityReadOperations entityReadOperations, SchemaWriteOperations schemaWriteOperations, SchemaReadOperations schemaReadOperations) {
        this.constraintSemantics = constraintSemantics;
        this.entityWriteOperations = entityWriteOperations;
        this.entityReadOperations = entityReadOperations;
        this.schemaWriteOperations = schemaWriteOperations;
        this.schemaReadOperations = schemaReadOperations;
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws ConstraintValidationKernelException, EntityNotFoundException {
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            NodeItem node = (NodeItem)cursor.get();
            Iterator<NodePropertyConstraint> allConstraints = this.schemaReadOperations.constraintsGetForLabel(state, labelId);
            Iterator<UniquenessConstraint> constraints = this.uniquePropertyConstraints(allConstraints);
            while (constraints.hasNext()) {
                UniquenessConstraint constraint = constraints.next();
                Object propertyValue = node.getProperty(constraint.descriptor().getPropertyKeyId());
                if (propertyValue == null) continue;
                this.validateNoExistingNodeWithLabelAndProperty(state, constraint, propertyValue, node.id());
            }
        }
        return this.entityWriteOperations.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws ConstraintValidationKernelException, EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            NodeItem node = (NodeItem)cursor.get();
            node.labels().visitKeys(labelId -> {
                int propertyKeyId = property.propertyKeyId();
                Iterator<UniquenessConstraint> constraintIterator = this.uniquePropertyConstraints(this.schemaReadOperations.constraintsGetForLabelAndPropertyKey(state, new NodePropertyDescriptor(labelId, propertyKeyId)));
                if (constraintIterator.hasNext()) {
                    UniquenessConstraint constraint = constraintIterator.next();
                    this.validateNoExistingNodeWithLabelAndProperty(state, constraint, property.value(), node.id());
                }
                return false;
            });
        }
        return this.entityWriteOperations.nodeSetProperty(state, nodeId, property);
    }

    private void validateNoExistingNodeWithLabelAndProperty(KernelStatement state, UniquenessConstraint constraint, Object value, long modifiedNode) throws ConstraintValidationKernelException {
        try {
            IndexDescriptor index = constraint.indexDescriptor();
            this.assertIndexOnline(state, IndexBoundary.map(index));
            state.locks().optimistic().acquireExclusive(state.lockTracer(), ResourceTypes.INDEX_ENTRY, ResourceTypes.indexEntryResourceId(index.getLabelId(), index.getPropertyKeyId(), Strings.prettyPrint(value)));
            long existing = this.entityReadOperations.nodeGetFromUniqueIndexSeek(state, IndexBoundary.map(index), value);
            if (existing != -1L && existing != modifiedNode) {
                throw new UniquePropertyConstraintViolationKernelException(index.getLabelId(), index.getPropertyKeyId(), value, existing);
            }
        }
        catch (IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintKernelException(e);
        }
    }

    private void assertIndexOnline(KernelStatement state, NewIndexDescriptor indexDescriptor) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        switch (this.schemaReadOperations.indexGetState(state, indexDescriptor)) {
            case ONLINE: {
                return;
            }
        }
        throw new IndexBrokenKernelException(this.schemaReadOperations.indexGetFailure(state, indexDescriptor));
    }

    private Iterator<UniquenessConstraint> uniquePropertyConstraints(Iterator<NodePropertyConstraint> constraints) {
        return new CastingIterator(constraints, UniquenessConstraint.class);
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.entityWriteOperations.nodeDelete(state, nodeId);
    }

    @Override
    public int nodeDetachDelete(KernelStatement state, long nodeId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException, KernelException {
        return this.entityWriteOperations.nodeDetachDelete(state, nodeId);
    }

    @Override
    public long relationshipCreate(KernelStatement statement, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        return this.entityWriteOperations.relationshipCreate(statement, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.entityWriteOperations.relationshipDelete(state, relationshipId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        return this.entityWriteOperations.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        return this.entityWriteOperations.relationshipSetProperty(state, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        return this.entityWriteOperations.graphSetProperty(state, property);
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        return this.entityWriteOperations.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        return this.entityWriteOperations.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        return this.entityWriteOperations.graphRemoveProperty(state, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return this.entityReadOperations.nodesGetForLabel(state, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexSeek(KernelStatement state, NewIndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexSeek(state, index, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByNumber(KernelStatement statement, NewIndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexRangeSeekByNumber(statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByString(KernelStatement statement, NewIndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexRangeSeekByString(statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByPrefix(KernelStatement state, NewIndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexRangeSeekByPrefix(state, index, prefix);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexScan(KernelStatement state, NewIndexDescriptor index) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexScan(state, index);
    }

    @Override
    public long nodeGetFromUniqueIndexSeek(KernelStatement state, NewIndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.assertIndexOnline(state, index);
        int labelId = index.schema().getLabelId();
        int propertyKeyId = index.schema().getPropertyIds()[0];
        String stringVal = "";
        if (null != value) {
            DefinedProperty property = Property.property(propertyKeyId, value);
            stringVal = property.valueAsString();
        }
        Locks.Client locks = state.locks().optimistic();
        LockTracer lockTracer = state.lockTracer();
        long indexEntryId = ResourceTypes.indexEntryResourceId(labelId, propertyKeyId, stringVal);
        locks.acquireShared(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
        long nodeId = this.entityReadOperations.nodeGetFromUniqueIndexSeek(state, index, value);
        if (-1L == nodeId) {
            locks.releaseShared(ResourceTypes.INDEX_ENTRY, indexEntryId);
            locks.acquireExclusive(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
            nodeId = this.entityReadOperations.nodeGetFromUniqueIndexSeek(state, index, value);
            if (-1L != nodeId) {
                locks.acquireShared(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
                locks.releaseExclusive(ResourceTypes.INDEX_ENTRY, indexEntryId);
            }
        }
        return nodeId;
    }

    @Override
    public long nodesCountIndexed(KernelStatement statement, NewIndexDescriptor index, long nodeId, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        return this.entityReadOperations.nodesCountIndexed(statement, index, nodeId, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexContainsScan(KernelStatement state, NewIndexDescriptor index, String term) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexContainsScan(state, index, term);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexEndsWithScan(KernelStatement state, NewIndexDescriptor index, String suffix) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexEndsWithScan(state, index, suffix);
    }

    @Override
    public boolean graphHasProperty(KernelStatement state, int propertyKeyId) {
        return this.entityReadOperations.graphHasProperty(state, propertyKeyId);
    }

    @Override
    public Object graphGetProperty(KernelStatement state, int propertyKeyId) {
        return this.entityReadOperations.graphGetProperty(state, propertyKeyId);
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys(KernelStatement state) {
        return this.entityReadOperations.graphGetPropertyKeys(state);
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        return this.entityWriteOperations.nodeCreate(statement);
    }

    @Override
    public PrimitiveLongIterator nodesGetAll(KernelStatement state) {
        return this.entityReadOperations.nodesGetAll(state);
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll(KernelStatement state) {
        return this.entityReadOperations.relationshipsGetAll(state);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(KernelStatement statement, long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        this.entityReadOperations.relationshipVisit(statement, relId, visitor);
    }

    @Override
    public Cursor<NodeItem> nodeCursorById(KernelStatement statement, long nodeId) throws EntityNotFoundException {
        return this.entityReadOperations.nodeCursorById(statement, nodeId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorById(KernelStatement statement, long relId) throws EntityNotFoundException {
        return this.entityReadOperations.relationshipCursorById(statement, relId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorGetAll(KernelStatement statement) {
        return this.entityReadOperations.relationshipCursorGetAll(statement);
    }

    @Override
    public NewIndexDescriptor indexCreate(KernelStatement state, NodePropertyDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException {
        return this.schemaWriteOperations.indexCreate(state, descriptor);
    }

    @Override
    public void indexDrop(KernelStatement state, NewIndexDescriptor descriptor) throws DropIndexFailureException {
        this.schemaWriteOperations.indexDrop(state, descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, NewIndexDescriptor descriptor) throws DropIndexFailureException {
        this.schemaWriteOperations.uniqueIndexDrop(state, descriptor);
    }

    @Override
    public UniquenessConstraint uniquePropertyConstraintCreate(KernelStatement state, NodePropertyDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, AlreadyIndexedException {
        return this.schemaWriteOperations.uniquePropertyConstraintCreate(state, descriptor);
    }

    @Override
    public NodePropertyExistenceConstraint nodePropertyExistenceConstraintCreate(KernelStatement state, NodePropertyDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException {
        EntityLoadingIterator nodes = new EntityLoadingIterator(this.nodesGetForLabel(state, descriptor.getLabelId()), id -> this.nodeCursorById(state, id));
        this.constraintSemantics.validateNodePropertyExistenceConstraint((Iterator<Cursor<NodeItem>>)((Object)nodes), descriptor);
        return this.schemaWriteOperations.nodePropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public RelationshipPropertyExistenceConstraint relationshipPropertyExistenceConstraintCreate(KernelStatement state, RelationshipPropertyDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException {
        try (Cursor<RelationshipItem> cursor = this.relationshipCursorGetAll(state);){
            this.constraintSemantics.validateRelationshipPropertyExistenceConstraint(cursor, descriptor);
        }
        return this.schemaWriteOperations.relationshipPropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public void constraintDrop(KernelStatement state, NodePropertyConstraint constraint) throws DropConstraintFailureException {
        this.schemaWriteOperations.constraintDrop(state, constraint);
    }

    @Override
    public void constraintDrop(KernelStatement state, RelationshipPropertyConstraint constraint) throws DropConstraintFailureException {
        this.schemaWriteOperations.constraintDrop(state, constraint);
    }

    @Override
    public long nodesGetCount(KernelStatement statement) {
        return this.entityReadOperations.nodesGetCount(statement);
    }

    @Override
    public long relationshipsGetCount(KernelStatement statement) {
        return this.entityReadOperations.relationshipsGetCount(statement);
    }

    @Override
    public boolean nodeExists(KernelStatement statement, long id) {
        return this.entityReadOperations.nodeExists(statement, id);
    }
}

