/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.constraints;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;

public abstract class NodePropertyConstraint
implements PropertyConstraint {
    protected final NodePropertyDescriptor descriptor;

    public NodePropertyConstraint(NodePropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public final int label() {
        return this.descriptor.getLabelId();
    }

    @Override
    public NodePropertyDescriptor descriptor() {
        return this.descriptor;
    }

    public boolean matches(NodePropertyDescriptor descriptor) {
        return this.descriptor.equals(descriptor);
    }

    public boolean matches(LabelSchemaDescriptor other) {
        return other != null && this.descriptor.getLabelId() == other.getLabelId() && this.descriptor.getPropertyKeyId() == other.getPropertyIds()[0];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePropertyConstraint that = (NodePropertyConstraint)o;
        return this.descriptor.equals(that.descriptor);
    }

    protected String labelName(TokenNameLookup tokenNameLookup) {
        String labelName = tokenNameLookup.labelGetName(this.descriptor.getLabelId());
        if (labelName.contains(":")) {
            return "`" + labelName + "`";
        }
        return labelName;
    }

    @Override
    public int hashCode() {
        return this.descriptor.hashCode();
    }
}

