/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.IndexDescriptorFactory;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.extension.dependency.HighestSelectionStrategy;
import org.neo4j.kernel.extension.dependency.NamedLabelScanStoreSelectionStrategy;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.logging.StoreLogService;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.PropertyDeleter;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.kernel.internal.EmbeddedGraphDatabase;
import org.neo4j.kernel.internal.StoreLocker;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.storageengine.api.Token;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchRelationship;
import org.neo4j.unsafe.batchinsert.DirectRecordAccessSet;
import org.neo4j.unsafe.batchinsert.internal.BatchRelationshipIterable;
import org.neo4j.unsafe.batchinsert.internal.BatchTokenHolder;
import org.neo4j.unsafe.batchinsert.internal.IndexConfigStoreProvider;

public class BatchInserterImpl
implements BatchInserter,
IndexConfigStoreProvider {
    private final LifeSupport life;
    private final NeoStores neoStores;
    private final IndexConfigStore indexStore;
    private final File storeDir;
    private final BatchTokenHolder propertyKeyTokens;
    private final BatchTokenHolder relationshipTypeTokens;
    private final BatchTokenHolder labelTokens;
    private final IdGeneratorFactory idGeneratorFactory;
    private final SchemaIndexProviderMap schemaIndexProviders;
    private final LabelScanStore labelScanStore;
    private final Log msgLog;
    private final SchemaCache schemaCache;
    private final Config config;
    private final BatchSchemaActions actions;
    private final StoreLocker storeLocker;
    private boolean labelsTouched;
    private boolean isShutdown;
    private final LongFunction<Label> labelIdToLabelFunction = new LongFunction<Label>(){

        @Override
        public Label apply(long from) {
            return Label.label((String)BatchInserterImpl.this.labelTokens.byId(IoPrimitiveUtils.safeCastLongToInt(from)).name());
        }
    };
    private final FlushStrategy flushStrategy;
    private final RelationshipCreator relationshipCreator;
    private final DirectRecordAccessSet recordAccess;
    private final PropertyTraverser propertyTraverser;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeletor;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipTypeTokenStore relationshipTypeTokenStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;
    private final PropertyStore propertyStore;
    private final RecordStore<RelationshipGroupRecord> relationshipGroupStore;
    private final SchemaStore schemaStore;
    private final NeoStoreIndexStoreView indexStoreView;
    private final LabelTokenStore labelTokenStore;
    private final Locks.Client noopLockClient = new NoOpClient();
    private final long maxNodeId;
    private final RecordCursors cursors;

    public BatchInserterImpl(File storeDir, FileSystemAbstraction fileSystem, Map<String, String> stringParams, Iterable<KernelExtensionFactory<?>> kernelExtensions) throws IOException {
        this.rejectAutoUpgrade(stringParams);
        Map<String, String> params = this.getDefaultParams();
        params.putAll(stringParams);
        this.config = Config.embeddedDefaults(params);
        this.life = new LifeSupport();
        this.storeDir = storeDir;
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, this.config, PageCacheTracer.NULL, (Log)NullLog.getInstance());
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        this.life.add((Lifecycle)new PageCacheLifecycle(pageCache));
        StoreLogService logService = (StoreLogService)this.life.add((Lifecycle)StoreLogService.inLogsDirectory(fileSystem, this.storeDir));
        this.msgLog = logService.getInternalLog(this.getClass());
        this.storeLocker = new StoreLocker(fileSystem);
        this.storeLocker.checkLock(this.storeDir);
        boolean dump = this.config.get(GraphDatabaseSettings.dump_configuration);
        this.idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem);
        LogProvider internalLogProvider = logService.getInternalLogProvider();
        RecordFormats recordFormats = RecordFormatSelector.selectForStoreOrConfig(this.config, storeDir, fileSystem, pageCache, internalLogProvider);
        StoreFactory sf = new StoreFactory(this.storeDir, this.config, this.idGeneratorFactory, pageCache, fileSystem, recordFormats, internalLogProvider);
        this.maxNodeId = recordFormats.node().getMaxId();
        if (dump) {
            this.dumpConfiguration(params, System.out);
        }
        this.msgLog.info(Thread.currentThread() + " Starting BatchInserter(" + this + ")");
        this.life.start();
        this.neoStores = sf.openAllNeoStores(true);
        this.neoStores.verifyStoreOk();
        this.nodeStore = this.neoStores.getNodeStore();
        this.relationshipStore = this.neoStores.getRelationshipStore();
        this.relationshipTypeTokenStore = this.neoStores.getRelationshipTypeTokenStore();
        this.propertyKeyTokenStore = this.neoStores.getPropertyKeyTokenStore();
        this.propertyStore = this.neoStores.getPropertyStore();
        this.relationshipGroupStore = this.neoStores.getRelationshipGroupStore();
        this.schemaStore = this.neoStores.getSchemaStore();
        this.labelTokenStore = this.neoStores.getLabelTokenStore();
        List indexes = this.propertyKeyTokenStore.getTokens(10000);
        this.propertyKeyTokens = new BatchTokenHolder(indexes);
        this.labelTokens = new BatchTokenHolder(this.labelTokenStore.getTokens(Integer.MAX_VALUE));
        List types = this.relationshipTypeTokenStore.getTokens(Integer.MAX_VALUE);
        this.relationshipTypeTokens = new BatchTokenHolder(types);
        this.indexStore = (IndexConfigStore)this.life.add((Lifecycle)new IndexConfigStore(this.storeDir, fileSystem));
        this.schemaCache = new SchemaCache(new StandardConstraintSemantics(), this.schemaStore);
        this.indexStoreView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, this.neoStores);
        Dependencies deps = new Dependencies();
        deps.satisfyDependencies(fileSystem, this.config, logService, this.indexStoreView, pageCache);
        KernelExtensions extensions = (KernelExtensions)this.life.add((Lifecycle)new KernelExtensions(new SimpleKernelContext(storeDir, DatabaseInfo.UNKNOWN, deps), kernelExtensions, deps, UnsatisfiedDependencyStrategies.ignore()));
        SchemaIndexProvider provider = extensions.resolveDependency(SchemaIndexProvider.class, HighestSelectionStrategy.getInstance());
        this.schemaIndexProviders = new DefaultSchemaIndexProviderMap(provider);
        this.labelScanStore = (LabelScanStore)this.life.add((Lifecycle)extensions.resolveDependency(LabelScanStoreProvider.class, new NamedLabelScanStoreSelectionStrategy(this.config)).getLabelScanStore());
        this.actions = new BatchSchemaActions();
        this.recordAccess = new DirectRecordAccessSet(this.neoStores);
        this.relationshipCreator = new RelationshipCreator(new RelationshipGroupGetter(this.relationshipGroupStore), this.relationshipGroupStore.getStoreHeaderInt());
        this.propertyTraverser = new PropertyTraverser();
        this.propertyCreator = new PropertyCreator(this.propertyStore, this.propertyTraverser);
        this.propertyDeletor = new PropertyDeleter(this.propertyTraverser);
        this.flushStrategy = new BatchedFlushStrategy(this.recordAccess, this.config.get(GraphDatabaseSettings.batch_inserter_batch_size));
        this.cursors = new RecordCursors(this.neoStores);
    }

    private Map<String, String> getDefaultParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GraphDatabaseSettings.pagecache_memory.name(), "32m");
        return params;
    }

    @Override
    public boolean nodeHasProperty(long node, String propertyName) {
        return this.primitiveHasProperty(this.getNodeRecord(node).forChangingData(), propertyName);
    }

    @Override
    public boolean relationshipHasProperty(long relationship, String propertyName) {
        return this.primitiveHasProperty(this.recordAccess.getRelRecords().getOrLoad(relationship, null).forReadingData(), propertyName);
    }

    @Override
    public void setNodeProperty(long node, String propertyName, Object propertyValue) {
        RecordAccess.RecordProxy<Long, NodeRecord, Void> nodeRecord = this.getNodeRecord(node);
        this.setPrimitiveProperty(nodeRecord, propertyName, propertyValue);
        this.flushStrategy.flush();
    }

    @Override
    public void setRelationshipProperty(long relationship, String propertyName, Object propertyValue) {
        RecordAccess.RecordProxy<Long, RelationshipRecord, Void> relationshipRecord = this.getRelationshipRecord(relationship);
        this.setPrimitiveProperty(relationshipRecord, propertyName, propertyValue);
        this.flushStrategy.flush();
    }

    @Override
    public void removeNodeProperty(long node, String propertyName) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        this.propertyDeletor.removeProperty(this.getNodeRecord(node), propertyKey, this.recordAccess.getPropertyRecords());
        this.flushStrategy.flush();
    }

    @Override
    public void removeRelationshipProperty(long relationship, String propertyName) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        this.propertyDeletor.removeProperty(this.getRelationshipRecord(relationship), propertyKey, this.recordAccess.getPropertyRecords());
        this.flushStrategy.flush();
    }

    @Override
    public IndexCreator createDeferredSchemaIndex(Label label) {
        return new IndexCreatorImpl(this.actions, label);
    }

    private void setPrimitiveProperty(RecordAccess.RecordProxy<Long, ? extends PrimitiveRecord, Void> primitiveRecord, String propertyName, Object propertyValue) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords = this.recordAccess.getPropertyRecords();
        this.propertyCreator.primitiveSetProperty(primitiveRecord, propertyKey, propertyValue, propertyRecords);
    }

    private void validateIndexCanBeCreated(int labelId, int[] propertyKeyIds) {
        this.verifyIndexOrUniquenessConstraintCanBeCreated(labelId, propertyKeyIds, "Index for given {label;property} already exists");
    }

    private void validateUniquenessConstraintCanBeCreated(int labelId, int[] propertyKeyIds) {
        this.verifyIndexOrUniquenessConstraintCanBeCreated(labelId, propertyKeyIds, "It is not allowed to create uniqueness constraints and indexes on the same {label;property}");
    }

    private void verifyIndexOrUniquenessConstraintCanBeCreated(int labelId, int[] propertyKeyIds, String errorMessage) {
        LabelSchemaDescriptor schemaDescriptor = SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds);
        ConstraintDescriptor constraintDescriptor = ConstraintDescriptorFactory.uniqueForLabel(labelId, propertyKeyIds);
        if (this.schemaCache.hasIndexRule(schemaDescriptor) || this.schemaCache.hasConstraintRule(constraintDescriptor)) {
            throw new ConstraintViolationException(errorMessage);
        }
    }

    private void validateNodePropertyExistenceConstraintCanBeCreated(int labelId, int[] propertyKeyIds) {
        ConstraintDescriptor constraintDescriptor = ConstraintDescriptorFactory.existsForLabel(labelId, propertyKeyIds);
        if (this.schemaCache.hasConstraintRule(constraintDescriptor)) {
            throw new ConstraintViolationException("Node property existence constraint for given {label;property} already exists");
        }
    }

    private void validateRelationshipConstraintCanBeCreated(int relTypeId, int propertyKeyId) {
        ConstraintDescriptor constraintDescriptor = ConstraintDescriptorFactory.existsForLabel(relTypeId, propertyKeyId);
        if (this.schemaCache.hasConstraintRule(constraintDescriptor)) {
            throw new ConstraintViolationException("Relationship property existence constraint for given {type;property} already exists");
        }
    }

    private void createIndexRule(int labelId, int[] propertyKeyIds) {
        IndexRule schemaRule = IndexRule.indexRule(this.schemaStore.nextId(), NewIndexDescriptorFactory.forLabel(labelId, propertyKeyIds), this.schemaIndexProviders.getDefaultProvider().getProviderDescriptor());
        for (DynamicRecord record : this.schemaStore.allocateFrom(schemaRule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(schemaRule);
        this.labelsTouched = true;
        this.flushStrategy.forceFlush();
    }

    private void repopulateAllIndexes() throws IOException, IndexEntryConflictException {
        if (!this.labelsTouched) {
            return;
        }
        IndexRule[] rules = this.getIndexesNeedingPopulation();
        IndexPopulator[] populators = new IndexPopulator[rules.length];
        int[] labelIds = new int[rules.length];
        int[] propertyKeyIds = new int[rules.length];
        for (int i = 0; i < labelIds.length; ++i) {
            IndexRule rule = rules[i];
            int labelId = rule.getSchemaDescriptor().getLabelId();
            int propertyKeyId2 = rule.getSchemaDescriptor().getPropertyIds()[0];
            labelIds[i] = labelId;
            propertyKeyIds[i] = propertyKeyId2;
            IndexDescriptor descriptor = IndexDescriptorFactory.of(labelId, propertyKeyId2);
            populators[i] = this.schemaIndexProviders.apply(rule.getProviderDescriptor()).getPopulator(rule.getId(), descriptor, IndexConfiguration.of(rule), new IndexSamplingConfig(this.config));
            populators[i].create();
        }
        Visitor propertyUpdateVisitor = updates -> {
            for (NodePropertyUpdate update : updates.getPropertyUpdates()) {
                int propertyKeyInQuestion = update.getPropertyKeyId();
                for (int i = 0; i < propertyKeyIds.length; ++i) {
                    if (propertyKeyIds[i] != propertyKeyInQuestion || !update.forLabel(labelIds[i])) continue;
                    try {
                        populators[i].add(Collections.singletonList(update));
                        continue;
                    }
                    catch (IndexEntryConflictException conflict) {
                        throw conflict.notAllowed(labelIds[i], propertyKeyIds[i]);
                    }
                }
            }
            return true;
        };
        InitialNodeLabelCreationVisitor labelUpdateVisitor = new InitialNodeLabelCreationVisitor();
        StoreScan<IOException> storeScan = this.indexStoreView.visitNodes(labelIds, propertyKeyId -> PrimitiveIntCollections.contains((int[])propertyKeyIds, (int)propertyKeyId), propertyUpdateVisitor, labelUpdateVisitor);
        storeScan.run();
        for (IndexPopulator populator : populators) {
            populator.verifyDeferredConstraints(this.indexStoreView);
            populator.close(true);
        }
        labelUpdateVisitor.close();
    }

    private void rebuildCounts() {
        CountsTracker counts = this.neoStores.getCounts();
        try {
            counts.start();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        CountsComputer.recomputeCounts(this.neoStores);
    }

    private IndexRule[] getIndexesNeedingPopulation() {
        ArrayList<IndexRule> indexesNeedingPopulation = new ArrayList<IndexRule>();
        for (IndexRule rule : this.schemaCache.indexRules()) {
            SchemaIndexProvider provider = this.schemaIndexProviders.apply(rule.getProviderDescriptor());
            if (provider.getInitialState(rule.getId()) == InternalIndexState.FAILED) continue;
            indexesNeedingPopulation.add(rule);
        }
        return indexesNeedingPopulation.toArray(new IndexRule[indexesNeedingPopulation.size()]);
    }

    @Override
    public ConstraintCreator createDeferredConstraint(Label label) {
        return new BaseNodeConstraintCreator(new BatchSchemaActions(), label);
    }

    private void createUniquenessConstraintRule(UniquenessConstraint constraint) {
        long indexRuleId = this.schemaStore.nextId();
        long constraintRuleId = this.schemaStore.nextId();
        int propertyKeyId = constraint.indexDescriptor().getPropertyKeyId();
        IndexRule indexRule = IndexRule.constraintIndexRule(indexRuleId, NewIndexDescriptorFactory.uniqueForLabel(constraint.label(), propertyKeyId), this.schemaIndexProviders.getDefaultProvider().getProviderDescriptor(), constraintRuleId);
        ConstraintRule constraintRule = ConstraintRule.constraintRule(constraintRuleId, ConstraintDescriptorFactory.uniqueForLabel(constraint.label(), propertyKeyId), indexRuleId);
        for (DynamicRecord record : this.schemaStore.allocateFrom(constraintRule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(constraintRule);
        for (DynamicRecord record : this.schemaStore.allocateFrom(indexRule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(indexRule);
        this.labelsTouched = true;
        this.flushStrategy.forceFlush();
    }

    private void createNodePropertyExistenceConstraintRule(int labelId, int ... propertyKeyIds) {
        ConstraintRule rule = ConstraintRule.constraintRule(this.schemaStore.nextId(), ConstraintDescriptorFactory.existsForLabel(labelId, propertyKeyIds));
        for (DynamicRecord record : this.schemaStore.allocateFrom(rule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(rule);
        this.labelsTouched = true;
        this.flushStrategy.forceFlush();
    }

    private void createRelTypePropertyExistenceConstraintRule(int relTypeId, int ... propertyKeyIds) {
        ConstraintRule rule = ConstraintRule.constraintRule(this.schemaStore.nextId(), ConstraintDescriptorFactory.existsForRelType(relTypeId, propertyKeyIds));
        for (DynamicRecord record : this.schemaStore.allocateFrom(rule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(rule);
        this.flushStrategy.forceFlush();
    }

    private int getOrCreatePropertyKeyId(String name) {
        int propertyKeyId = this.tokenIdByName(this.propertyKeyTokens, name);
        if (propertyKeyId == -1) {
            propertyKeyId = this.createNewPropertyKeyId(name);
        }
        return propertyKeyId;
    }

    private int getOrCreateRelationshipTypeToken(RelationshipType type) {
        int typeId = this.tokenIdByName(this.relationshipTypeTokens, type.name());
        if (typeId == -1) {
            typeId = this.createNewRelationshipType(type.name());
        }
        return typeId;
    }

    private int getOrCreateLabelId(String name) {
        int labelId = this.tokenIdByName(this.labelTokens, name);
        if (labelId == -1) {
            labelId = this.createNewLabelId(name);
        }
        return labelId;
    }

    private int getOrCreateRelationshipTypeId(String name) {
        int relationshipTypeId = this.tokenIdByName(this.relationshipTypeTokens, name);
        if (relationshipTypeId == -1) {
            relationshipTypeId = this.createNewRelationshipType(name);
        }
        return relationshipTypeId;
    }

    private int tokenIdByName(BatchTokenHolder tokens, String name) {
        Token token = tokens.byName(name);
        return token != null ? token.id() : -1;
    }

    private boolean primitiveHasProperty(PrimitiveRecord record, String propertyName) {
        int propertyKeyId = this.tokenIdByName(this.propertyKeyTokens, propertyName);
        return propertyKeyId != -1 && this.propertyTraverser.findPropertyRecordContaining(record, propertyKeyId, this.recordAccess.getPropertyRecords(), false) != (long)Record.NO_NEXT_PROPERTY.intValue();
    }

    private void rejectAutoUpgrade(Map<String, String> params) {
        if (Boolean.parseBoolean(params.get(GraphDatabaseSettings.allow_store_upgrade.name()))) {
            throw new IllegalArgumentException("Batch inserter is not allowed to do upgrade of a store, use " + EmbeddedGraphDatabase.class.getSimpleName() + " instead");
        }
    }

    @Override
    public long createNode(Map<String, Object> properties, Label ... labels) {
        return this.internalCreateNode(this.nodeStore.nextId(), properties, labels);
    }

    private long internalCreateNode(long nodeId, Map<String, Object> properties, Label ... labels) {
        NodeRecord nodeRecord = this.recordAccess.getNodeRecords().create(nodeId, null).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
        nodeRecord.setNextProp(this.propertyCreator.createPropertyChain(nodeRecord, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        if (labels.length > 0) {
            this.setNodeLabels(nodeRecord, labels);
        }
        this.flushStrategy.flush();
        return nodeId;
    }

    private Iterator<PropertyBlock> propertiesIterator(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return Iterators.emptyIterator();
        }
        return new IteratorWrapper<PropertyBlock, Map.Entry<String, Object>>(properties.entrySet().iterator()){

            protected PropertyBlock underlyingObjectToObject(Map.Entry<String, Object> property) {
                return BatchInserterImpl.this.propertyCreator.encodePropertyValue(BatchInserterImpl.this.getOrCreatePropertyKeyId(property.getKey()), property.getValue());
            }
        };
    }

    private void setNodeLabels(NodeRecord nodeRecord, Label ... labels) {
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField(nodeRecord);
        nodeLabels.put(this.getOrCreateLabelIds(labels), this.nodeStore, this.nodeStore.getDynamicLabelStore());
        this.labelsTouched = true;
    }

    private long[] getOrCreateLabelIds(Label[] labels) {
        long[] ids = new long[labels.length];
        int cursor = 0;
        for (int i = 0; i < ids.length; ++i) {
            int labelId = this.getOrCreateLabelId(labels[i].name());
            if (this.arrayContains(ids, cursor, labelId)) continue;
            ids[cursor++] = labelId;
        }
        if (cursor < ids.length) {
            ids = Arrays.copyOf(ids, cursor);
        }
        return ids;
    }

    private boolean arrayContains(long[] ids, int cursor, int labelId) {
        for (int i = 0; i < cursor; ++i) {
            if (ids[i] != (long)labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createNode(long id, Map<String, Object> properties, Label ... labels) {
        IdValidator.assertValidId(id, this.maxNodeId);
        if (this.nodeStore.isInUse(id)) {
            throw new IllegalArgumentException("id=" + id + " already in use");
        }
        long highId = this.nodeStore.getHighId();
        if (highId <= id) {
            this.nodeStore.setHighestPossibleIdInUse(id);
        }
        this.internalCreateNode(id, properties, labels);
    }

    @Override
    public void setNodeLabels(long node, Label ... labels) {
        NodeRecord record = this.getNodeRecord(node).forChangingData();
        this.setNodeLabels(record, labels);
        this.flushStrategy.flush();
    }

    @Override
    public Iterable<Label> getNodeLabels(long node) {
        return () -> {
            NodeRecord record = this.getNodeRecord(node).forReadingData();
            long[] labels = NodeLabelsField.parseLabelsField(record).get(this.nodeStore);
            return PrimitiveLongCollections.map(this.labelIdToLabelFunction, (PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])labels));
        };
    }

    @Override
    public boolean nodeHasLabel(long node, Label label) {
        int labelId = this.tokenIdByName(this.labelTokens, label.name());
        return labelId != -1 && this.nodeHasLabel(node, labelId);
    }

    private boolean nodeHasLabel(long node, int labelId) {
        NodeRecord record = this.getNodeRecord(node).forReadingData();
        for (long label : NodeLabelsField.parseLabelsField(record).get(this.nodeStore)) {
            if (label != (long)labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public long createRelationship(long node1, long node2, RelationshipType type, Map<String, Object> properties) {
        long id = this.relationshipStore.nextId();
        int typeId = this.getOrCreateRelationshipTypeToken(type);
        this.relationshipCreator.relationshipCreate(id, typeId, node1, node2, this.recordAccess, this.noopLockClient);
        if (properties != null && !properties.isEmpty()) {
            RelationshipRecord record = this.recordAccess.getRelRecords().getOrLoad(id, null).forChangingData();
            record.setNextProp(this.propertyCreator.createPropertyChain(record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        }
        this.flushStrategy.flush();
        return id;
    }

    @Override
    public void setNodeProperties(long node, Map<String, Object> properties) {
        NodeRecord record = this.getNodeRecord(node).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.propertyDeletor.deletePropertyChain(record, this.recordAccess.getPropertyRecords());
        }
        record.setNextProp(this.propertyCreator.createPropertyChain(record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        this.flushStrategy.flush();
    }

    @Override
    public void setRelationshipProperties(long rel, Map<String, Object> properties) {
        RelationshipRecord record = this.recordAccess.getRelRecords().getOrLoad(rel, null).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.propertyDeletor.deletePropertyChain(record, this.recordAccess.getPropertyRecords());
        }
        record.setNextProp(this.propertyCreator.createPropertyChain(record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        this.flushStrategy.flush();
    }

    @Override
    public boolean nodeExists(long nodeId) {
        this.flushStrategy.forceFlush();
        return this.nodeStore.isInUse(nodeId);
    }

    @Override
    public Map<String, Object> getNodeProperties(long nodeId) {
        NodeRecord record = this.getNodeRecord(nodeId).forReadingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public Iterable<Long> getRelationshipIds(long nodeId) {
        this.flushStrategy.forceFlush();
        return new BatchRelationshipIterable<Long>(this.neoStores, nodeId, this.cursors){

            @Override
            protected Long nextFrom(long relId, int type, long startNode, long endNode) {
                return relId;
            }
        };
    }

    @Override
    public Iterable<BatchRelationship> getRelationships(long nodeId) {
        this.flushStrategy.forceFlush();
        return new BatchRelationshipIterable<BatchRelationship>(this.neoStores, nodeId, this.cursors){

            @Override
            protected BatchRelationship nextFrom(long relId, int type, long startNode, long endNode) {
                return new BatchRelationship(relId, startNode, endNode, (RelationshipType)BatchInserterImpl.this.relationshipTypeTokens.byId(type));
            }
        };
    }

    @Override
    public BatchRelationship getRelationshipById(long relId) {
        RelationshipRecord record = this.getRelationshipRecord(relId).forReadingData();
        RelationshipType type = (RelationshipType)this.relationshipTypeTokens.byId(record.getType());
        return new BatchRelationship(record.getId(), record.getFirstNode(), record.getSecondNode(), type);
    }

    @Override
    public Map<String, Object> getRelationshipProperties(long relId) {
        RelationshipRecord record = this.recordAccess.getRelRecords().getOrLoad(relId, null).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void shutdown() {
        if (this.isShutdown) {
            throw new IllegalStateException("Batch inserter already has shutdown");
        }
        this.isShutdown = true;
        this.flushStrategy.forceFlush();
        this.rebuildCounts();
        try {
            this.repopulateAllIndexes();
            this.cursors.close();
            this.neoStores.close();
        }
        catch (IOException | IndexEntryConflictException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.cursors.close();
                this.neoStores.close();
                try {
                    this.storeLocker.close();
                }
                catch (IOException e2) {
                    throw new UnderlyingStorageException("Could not release store lock", e2);
                }
                this.msgLog.info(Thread.currentThread() + " Clean shutdown on BatchInserter(" + this + ")", new Object[]{true});
                this.life.shutdown();
                throw throwable;
            }
        }
        try {
            this.storeLocker.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Could not release store lock", e);
        }
        this.msgLog.info(Thread.currentThread() + " Clean shutdown on BatchInserter(" + this + ")", new Object[]{true});
        this.life.shutdown();
    }

    public String toString() {
        return "EmbeddedBatchInserter[" + this.storeDir + "]";
    }

    private Map<String, Object> getPropertyChain(long nextProp) {
        final HashMap<String, Object> map = new HashMap<String, Object>();
        this.propertyTraverser.getPropertyChain(nextProp, this.recordAccess.getPropertyRecords(), new Listener<PropertyBlock>(){

            @Override
            public void receive(PropertyBlock propBlock) {
                String key = BatchInserterImpl.this.propertyKeyTokens.byId(propBlock.getKeyIndexId()).name();
                DefinedProperty propertyData = propBlock.newPropertyData(BatchInserterImpl.this.propertyStore);
                Object value = propertyData.value() != null ? propertyData.value() : propBlock.getType().getValue(propBlock, BatchInserterImpl.this.propertyStore);
                map.put(key, value);
            }
        });
        return map;
    }

    private int createNewPropertyKeyId(String stringKey) {
        int keyId = (int)this.propertyKeyTokenStore.nextId();
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(keyId);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> keyRecords = this.propertyKeyTokenStore.allocateNameRecords(PropertyStore.encodeString(stringKey));
        record.setNameId((int)((DynamicRecord)Iterables.first(keyRecords)).getId());
        record.addNameRecords(keyRecords);
        this.propertyKeyTokenStore.updateRecord(record);
        this.propertyKeyTokens.addToken(new Token(stringKey, keyId));
        return keyId;
    }

    private int createNewLabelId(String stringKey) {
        int keyId = (int)this.labelTokenStore.nextId();
        LabelTokenRecord record = new LabelTokenRecord(keyId);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> keyRecords = this.labelTokenStore.allocateNameRecords(PropertyStore.encodeString(stringKey));
        record.setNameId((int)((DynamicRecord)Iterables.first(keyRecords)).getId());
        record.addNameRecords(keyRecords);
        this.labelTokenStore.updateRecord(record);
        this.labelTokens.addToken(new Token(stringKey, keyId));
        return keyId;
    }

    private int createNewRelationshipType(String name) {
        int id = (int)this.relationshipTypeTokenStore.nextId();
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> nameRecords = this.relationshipTypeTokenStore.allocateNameRecords(PropertyStore.encodeString(name));
        record.setNameId((int)((DynamicRecord)Iterables.first(nameRecords)).getId());
        record.addNameRecords(nameRecords);
        this.relationshipTypeTokenStore.updateRecord(record);
        this.relationshipTypeTokens.addToken(new RelationshipTypeToken(name, id));
        return id;
    }

    private RecordAccess.RecordProxy<Long, NodeRecord, Void> getNodeRecord(long id) {
        if (id < 0L || id >= this.nodeStore.getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.recordAccess.getNodeRecords().getOrLoad(id, null);
    }

    private RecordAccess.RecordProxy<Long, RelationshipRecord, Void> getRelationshipRecord(long id) {
        if (id < 0L || id >= this.relationshipStore.getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.recordAccess.getRelRecords().getOrLoad(id, null);
    }

    @Override
    public String getStoreDir() {
        return this.storeDir.getPath();
    }

    @Override
    public IndexConfigStore getIndexStore() {
        return this.indexStore;
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    private void dumpConfiguration(Map<String, String> config, PrintStream out) {
        for (String key : config.keySet()) {
            String value = config.get(key);
            if (value == null) continue;
            out.println(key + "=" + value);
        }
    }

    NeoStores getNeoStores() {
        return this.neoStores;
    }

    void forceFlushChanges() {
        this.flushStrategy.forceFlush();
    }

    static final class BatchedFlushStrategy
    implements FlushStrategy {
        private final DirectRecordAccessSet directRecordAccess;
        private final int batchSize;
        private int attempts;

        public BatchedFlushStrategy(DirectRecordAccessSet directRecordAccess, int batchSize) {
            this.directRecordAccess = directRecordAccess;
            this.batchSize = batchSize;
        }

        @Override
        public void flush() {
            ++this.attempts;
            if (this.attempts >= this.batchSize) {
                this.forceFlush();
            }
        }

        @Override
        public void forceFlush() {
            this.directRecordAccess.commit();
            this.attempts = 0;
        }
    }

    static interface FlushStrategy {
        public void flush();

        public void forceFlush();
    }

    private class BatchSchemaActions
    implements InternalSchemaActions {
        private BatchSchemaActions() {
        }

        private int[] getOrCreatePropertyKeyIds(Iterable<String> properties) {
            return Iterables.stream(properties).mapToInt(x$0 -> BatchInserterImpl.this.getOrCreatePropertyKeyId(x$0)).toArray();
        }

        private int[] getOrCreatePropertyKeyIds(String[] properties) {
            return Arrays.stream(properties).mapToInt(x$0 -> BatchInserterImpl.this.getOrCreatePropertyKeyId(x$0)).toArray();
        }

        @Override
        public IndexDefinition createIndexDefinition(Label label, String ... propertyKeys) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(label.name());
            int[] propertyKeyIds = this.getOrCreatePropertyKeyIds(propertyKeys);
            BatchInserterImpl.this.validateIndexCanBeCreated(labelId, propertyKeyIds);
            BatchInserterImpl.this.createIndexRule(labelId, propertyKeyIds);
            return new IndexDefinitionImpl((InternalSchemaActions)this, label, propertyKeys, false);
        }

        @Override
        public void dropIndexDefinitions(IndexDefinition indexDefinition) {
            throw this.unsupportedException();
        }

        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(IndexDefinition indexDefinition) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(indexDefinition.getLabel().name());
            int[] propertyKeyIds = this.getOrCreatePropertyKeyIds(indexDefinition.getPropertyKeys());
            NodePropertyDescriptor descriptor = IndexDescriptorFactory.getNodePropertyDescriptor(labelId, propertyKeyIds);
            BatchInserterImpl.this.validateUniquenessConstraintCanBeCreated(labelId, propertyKeyIds);
            BatchInserterImpl.this.createUniquenessConstraintRule(new UniquenessConstraint(descriptor));
            return new UniquenessConstraintDefinition((InternalSchemaActions)this, indexDefinition);
        }

        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(Label label, String ... propertyKeys) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(label.name());
            int[] propertyKeyIds = this.getOrCreatePropertyKeyIds(propertyKeys);
            BatchInserterImpl.this.validateNodePropertyExistenceConstraintCanBeCreated(labelId, propertyKeyIds);
            BatchInserterImpl.this.createNodePropertyExistenceConstraintRule(labelId, propertyKeyIds);
            return new NodePropertyExistenceConstraintDefinition(this, label, propertyKeys);
        }

        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(RelationshipType type, String propertyKey) throws CreateConstraintFailureException, AlreadyConstrainedException {
            int relationshipTypeId = BatchInserterImpl.this.getOrCreateRelationshipTypeId(type.name());
            int propertyKeyId = BatchInserterImpl.this.getOrCreatePropertyKeyId(propertyKey);
            BatchInserterImpl.this.validateRelationshipConstraintCanBeCreated(relationshipTypeId, propertyKeyId);
            BatchInserterImpl.this.createRelTypePropertyExistenceConstraintRule(relationshipTypeId, new int[]{propertyKeyId});
            return new RelationshipPropertyExistenceConstraintDefinition(this, type, propertyKey);
        }

        @Override
        public void dropPropertyUniquenessConstraint(IndexDefinition indexDefinition) {
            throw this.unsupportedException();
        }

        @Override
        public void dropNodePropertyExistenceConstraint(IndexDefinition indexDefinition) {
            throw this.unsupportedException();
        }

        @Override
        public void dropRelationshipPropertyExistenceConstraint(RelationshipType type, String propertyKey) {
            throw this.unsupportedException();
        }

        @Override
        public String getUserMessage(KernelException e) {
            throw this.unsupportedException();
        }

        @Override
        public void assertInOpenTransaction() {
        }

        private UnsupportedOperationException unsupportedException() {
            return new UnsupportedOperationException("Batch inserter doesn't support this");
        }
    }

    private class InitialNodeLabelCreationVisitor
    implements Visitor<NodeLabelUpdate, IOException> {
        LabelScanWriter writer;

        private InitialNodeLabelCreationVisitor() {
            this.writer = BatchInserterImpl.this.labelScanStore.newWriter();
        }

        public boolean visit(NodeLabelUpdate update) throws IOException {
            this.writer.write(update);
            return true;
        }

        public void close() throws IOException {
            this.writer.close();
        }
    }
}

