/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.impl.util.DebugUtil;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Neo4jJobScheduler
extends LifecycleAdapter
implements JobScheduler {
    private ExecutorService globalPool;
    private ScheduledThreadPoolExecutor scheduledExecutor;
    private final Set<JobScheduler.JobHandle> jobs = Collections.synchronizedSet(new HashSet());

    public void init() {
        this.globalPool = Executors.newCachedThreadPool(NamedThreadFactory.daemon("neo4j.Pooled" + DebugUtil.trackTest()));
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(2, NamedThreadFactory.daemon("neo4j.Scheduled" + DebugUtil.trackTest()));
    }

    @Override
    public Executor executor(JobScheduler.Group group) {
        return job -> this.schedule(group, job);
    }

    @Override
    public ThreadFactory threadFactory(JobScheduler.Group group) {
        return job -> this.createNewThread(group, job, JobScheduler.Group.NO_METADATA);
    }

    @Override
    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job) {
        return this.schedule(group, job, JobScheduler.Group.NO_METADATA);
    }

    @Override
    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job, Map<String, String> metadata) {
        if (this.globalPool == null) {
            throw new RejectedExecutionException("Scheduler is not started");
        }
        switch (group.strategy()) {
            case POOLED: {
                return this.register(new PooledJobHandle(this.globalPool.submit(job)));
            }
            case NEW_THREAD: {
                Thread thread = this.createNewThread(group, job, metadata);
                thread.start();
                return new SingleThreadHandle(thread);
            }
        }
        throw new IllegalArgumentException("Unsupported strategy for scheduling job: " + (Object)((Object)group.strategy()));
    }

    private JobScheduler.JobHandle register(final PooledJobHandle pooledJobHandle) {
        this.jobs.add(pooledJobHandle);
        return new JobScheduler.JobHandle(){

            @Override
            public void waitTermination() throws InterruptedException, ExecutionException {
                pooledJobHandle.waitTermination();
            }

            @Override
            public void cancel(boolean mayInterruptIfRunning) {
                pooledJobHandle.cancel(mayInterruptIfRunning);
                Neo4jJobScheduler.this.jobs.remove(pooledJobHandle);
            }

            @Override
            public void registerCancelListener(JobScheduler.CancelListener listener) {
                pooledJobHandle.registerCancelListener(listener);
            }
        };
    }

    @Override
    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        return this.scheduleRecurring(group, runnable, 0L, period, timeUnit);
    }

    @Override
    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        switch (group.strategy()) {
            case POOLED: {
                return new PooledJobHandle(this.scheduledExecutor.scheduleAtFixedRate(runnable, initialDelay, period, timeUnit));
            }
        }
        throw new IllegalArgumentException("Unsupported strategy to use for recurring jobs: " + (Object)((Object)group.strategy()));
    }

    @Override
    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
        switch (group.strategy()) {
            case POOLED: {
                return new PooledJobHandle(this.scheduledExecutor.schedule(runnable, initialDelay, timeUnit));
            }
        }
        throw new IllegalArgumentException("Unsupported strategy to use for delayed jobs: " + (Object)((Object)group.strategy()));
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        RuntimeException exception = null;
        try {
            for (JobScheduler.JobHandle handle : this.jobs) {
                handle.cancel(true);
            }
            this.jobs.clear();
            this.shutdownPool(this.globalPool);
        }
        catch (RuntimeException e) {
            exception = e;
        }
        finally {
            this.globalPool = null;
        }
        try {
            this.shutdownPool(this.scheduledExecutor);
        }
        catch (RuntimeException e) {
            exception = (RuntimeException)Exceptions.chain((Throwable)exception, (Throwable)e);
        }
        finally {
            this.scheduledExecutor = null;
        }
        if (exception != null) {
            throw new RuntimeException("Unable to shut down job scheduler properly.", exception);
        }
    }

    private void shutdownPool(ExecutorService pool) {
        if (pool != null) {
            pool.shutdown();
            try {
                pool.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Thread createNewThread(JobScheduler.Group group, Runnable job, Map<String, String> metadata) {
        Thread thread = new Thread(null, job, group.threadName(metadata));
        thread.setDaemon(true);
        return thread;
    }

    private static class SingleThreadHandle
    implements JobScheduler.JobHandle {
        private final Thread thread;

        public SingleThreadHandle(Thread thread) {
            this.thread = thread;
        }

        @Override
        public void cancel(boolean mayInterruptIfRunning) {
            if (mayInterruptIfRunning) {
                this.thread.interrupt();
            }
        }

        @Override
        public void waitTermination() throws InterruptedException {
            this.thread.join();
        }
    }

    private static class PooledJobHandle
    implements JobScheduler.JobHandle {
        private final Future<?> job;
        private final List<JobScheduler.CancelListener> cancelListeners = new CopyOnWriteArrayList<JobScheduler.CancelListener>();

        public PooledJobHandle(Future<?> job) {
            this.job = job;
        }

        @Override
        public void cancel(boolean mayInterruptIfRunning) {
            this.job.cancel(mayInterruptIfRunning);
            for (JobScheduler.CancelListener cancelListener : this.cancelListeners) {
                cancelListener.cancelled(mayInterruptIfRunning);
            }
        }

        @Override
        public void waitTermination() throws InterruptedException, ExecutionException {
            this.job.get();
        }

        @Override
        public void registerCancelListener(JobScheduler.CancelListener listener) {
            this.cancelListeners.add(listener);
        }
    }
}

