/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.RecordSerializable;
import org.neo4j.storageengine.api.schema.SchemaRule;

public abstract class AbstractSchemaRule
implements SchemaRule,
RecordSerializable {
    protected final long id;

    public AbstractSchemaRule(long id) {
        this.id = id;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    public static SchemaRule deserialize(long id, ByteBuffer buffer) throws MalformedSchemaRuleException {
        int labelId = buffer.getInt();
        SchemaRule.Kind kind = SchemaRule.Kind.forId(buffer.get());
        try {
            SchemaRule rule = AbstractSchemaRule.newRule(kind, id, labelId, buffer);
            if (null == rule) {
                throw new MalformedSchemaRuleException(null, "Deserialized null schema rule for id %d with kind %s", new Object[]{id, kind.name()});
            }
            return rule;
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException(e, "Could not deserialize schema rule for id %d with kind %s", id, kind.name());
        }
    }

    private static SchemaRule newRule(SchemaRule.Kind kind, long id, int labelId, ByteBuffer buffer) {
        switch (kind) {
            case INDEX_RULE: {
                return IndexRule.readIndexRule(id, false, labelId, buffer);
            }
            case CONSTRAINT_INDEX_RULE: {
                return IndexRule.readIndexRule(id, true, labelId, buffer);
            }
            case UNIQUENESS_CONSTRAINT: {
                return ConstraintRule.readUniquenessConstraintRule(id, labelId, buffer);
            }
            case NODE_PROPERTY_EXISTENCE_CONSTRAINT: {
                return ConstraintRule.readNodePropertyExistenceConstraintRule(id, labelId, buffer);
            }
            case RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT: {
                return ConstraintRule.readRelPropertyExistenceConstraintRule(id, labelId, buffer);
            }
        }
        throw new IllegalArgumentException(kind.name());
    }
}

