/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.io.File;
import java.net.URL;
import java.util.function.Supplier;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.legacyindex.AutoIndexing;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.ProcedureGDBFacadeSPI;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.store.StoreId;

public class ProcedureGDSFactory
implements ThrowingFunction<Context, GraphDatabaseService, ProcedureException> {
    private Config config;
    private final File storeDir;
    private final DependencyResolver resolver;
    private final Supplier<StoreId> storeId;
    private final Supplier<QueryExecutionEngine> queryExecutor;
    private final CoreAPIAvailabilityGuard availability;
    private final ThrowingFunction<URL, URL, URLAccessValidationError> urlValidator;
    private final Guard guard;
    private final ThreadToStatementContextBridge txBridge;

    public ProcedureGDSFactory(Config config, File storeDir, DependencyResolver resolver, Supplier<StoreId> storeId, Supplier<QueryExecutionEngine> queryExecutor, CoreAPIAvailabilityGuard availability, URLAccessRule urlAccessRule) {
        this.config = config;
        this.storeDir = storeDir;
        this.resolver = resolver;
        this.storeId = storeId;
        this.queryExecutor = queryExecutor;
        this.availability = availability;
        this.urlValidator = url -> urlAccessRule.validate((Configuration)config, url);
        this.guard = (Guard)resolver.resolveDependency(Guard.class);
        this.txBridge = (ThreadToStatementContextBridge)resolver.resolveDependency(ThreadToStatementContextBridge.class);
    }

    public GraphDatabaseService apply(Context context) throws ProcedureException {
        KernelTransaction transaction = context.get(Context.KERNEL_TRANSACTION);
        Thread owningThread = context.get(Context.THREAD);
        GraphDatabaseFacade facade = new GraphDatabaseFacade();
        facade.init(new ProcedureGDBFacadeSPI(owningThread, transaction, this.queryExecutor, this.storeDir, this.resolver, AutoIndexing.UNSUPPORTED, this.storeId, this.availability, this.urlValidator), this.guard, this.txBridge, this.config);
        return facade;
    }
}

