/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.kernel.configuration.Config;

public class ProcedureAllowedConfig {
    public static final String PROC_ALLOWED_SETTING_DEFAULT_NAME = "dbms.security.procedures.default_allowed";
    public static final String PROC_ALLOWED_SETTING_ROLES = "dbms.security.procedures.roles";
    private static final String ROLES_DELIMITER = ",";
    private static final String SETTING_DELIMITER = ";";
    private static final String MAPPING_DELIMITER = ":";
    private final String defaultValue;
    private final List<ProcMatcher> matchers;
    static final ProcedureAllowedConfig DEFAULT = new ProcedureAllowedConfig();

    private ProcedureAllowedConfig() {
        this.defaultValue = "";
        this.matchers = Collections.emptyList();
    }

    public ProcedureAllowedConfig(Config config) {
        this.defaultValue = config.getValue(PROC_ALLOWED_SETTING_DEFAULT_NAME).map(Object::toString).orElse("");
        String allowedRoles = config.getValue(PROC_ALLOWED_SETTING_ROLES).map(Object::toString).orElse("");
        this.matchers = allowedRoles.isEmpty() ? Collections.emptyList() : Stream.of(allowedRoles.split(SETTING_DELIMITER)).map(procToRoleSpec -> {
            String[] spec = procToRoleSpec.split(MAPPING_DELIMITER);
            String[] roles = (String[])Arrays.stream(spec[1].split(ROLES_DELIMITER)).map(String::trim).toArray(String[]::new);
            return new ProcMatcher(spec[0].trim(), roles);
        }).collect(Collectors.toList());
    }

    String[] rolesFor(String procedureName) {
        String[] wildCardRoles = this.matchers.stream().filter(matcher -> matcher.matches(procedureName)).map(ProcMatcher::roles).reduce(new String[0], (acc, next) -> (String[])Stream.concat(Arrays.stream(acc), Arrays.stream(next)).toArray(String[]::new));
        if (wildCardRoles.length > 0) {
            return wildCardRoles;
        }
        return this.getDefaultValue();
    }

    private String[] getDefaultValue() {
        String[] stringArray;
        if (this.defaultValue == null || this.defaultValue.isEmpty()) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.defaultValue;
        }
        return stringArray;
    }

    private static class ProcMatcher {
        private final Pattern pattern;
        private final String[] roles;

        private ProcMatcher(String procedurePattern, String[] roles) {
            this.pattern = Pattern.compile(procedurePattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"));
            this.roles = roles;
        }

        boolean matches(String procedureName) {
            return this.pattern.matcher(procedureName).matches();
        }

        String[] roles() {
            return this.roles;
        }
    }
}

