/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.cursor.RawCursor;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.NodeLabelRange;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;

class NativeAllEntriesLabelScanReader
implements AllEntriesLabelScanReader {
    private final IntFunction<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> seekProvider;
    private final List<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> cursors = new ArrayList<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>>();
    private final int highestLabelId;

    NativeAllEntriesLabelScanReader(IntFunction<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> seekProvider, int highestLabelId) {
        this.seekProvider = seekProvider;
        this.highestLabelId = highestLabelId;
    }

    @Override
    public long maxCount() {
        return -1L;
    }

    @Override
    public Iterator<NodeLabelRange> iterator() {
        try {
            long lowestRange = Long.MAX_VALUE;
            this.closeCursors();
            for (int labelId = 0; labelId <= this.highestLabelId; ++labelId) {
                RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor = this.seekProvider.apply(labelId);
                if (!cursor.next()) continue;
                lowestRange = Long.min(lowestRange, ((LabelScanKey)((Hit)cursor.get()).key()).idRange);
                this.cursors.add(cursor);
            }
            return new NodeLabelRangeIterator(lowestRange);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeCursors() throws IOException {
        for (RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor : this.cursors) {
            cursor.close();
        }
        this.cursors.clear();
    }

    @Override
    public void close() throws Exception {
        this.closeCursors();
    }

    private static class NativeNodeLabelRange
    implements NodeLabelRange {
        private final long idRange;
        private final long[] nodes;
        private final long[][] labels;

        NativeNodeLabelRange(long idRange, long[][] labels, int slots) {
            this.idRange = idRange;
            this.labels = labels;
            long baseNodeId = idRange * 64L;
            this.nodes = new long[slots];
            int nodeIndex = 0;
            for (int i = 0; i < 64; ++i) {
                if (labels[i] == null) continue;
                this.nodes[nodeIndex++] = baseNodeId + (long)i;
            }
        }

        @Override
        public int id() {
            return (int)this.idRange;
        }

        @Override
        public long[] nodes() {
            return this.nodes;
        }

        @Override
        public long[] labels(long nodeId) {
            long firstNodeId = this.idRange * 64L;
            int index = Math.toIntExact(nodeId - firstNodeId);
            assert (index >= 0 && index < 64) : "nodeId:" + nodeId + ", idRange:" + this.idRange;
            return this.labels[index];
        }
    }

    private class NodeLabelRangeIterator
    extends PrefetchingIterator<NodeLabelRange> {
        private long currentRange;
        private final List<Long>[] labelsForEachNode = new List[64];

        NodeLabelRangeIterator(long lowestRange) {
            this.currentRange = lowestRange;
        }

        protected NodeLabelRange fetchNextOrNull() {
            if (this.currentRange == Long.MAX_VALUE) {
                return null;
            }
            Arrays.fill(this.labelsForEachNode, null);
            long nextLowestRange = Long.MAX_VALUE;
            int slots = 0;
            try {
                for (RawCursor cursor : NativeAllEntriesLabelScanReader.this.cursors) {
                    long idRange = ((LabelScanKey)((Hit)cursor.get()).key()).idRange;
                    if (idRange < this.currentRange) {
                        assert (!cursor.next());
                        continue;
                    }
                    if (idRange == this.currentRange) {
                        slots = this.readRange(slots, (RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>)cursor);
                        if (!cursor.next()) continue;
                        nextLowestRange = Long.min(nextLowestRange, ((LabelScanKey)((Hit)cursor.get()).key()).idRange);
                        continue;
                    }
                    nextLowestRange = Long.min(nextLowestRange, ((LabelScanKey)((Hit)cursor.get()).key()).idRange);
                }
                NativeNodeLabelRange range = new NativeNodeLabelRange(this.currentRange, this.convertState(), slots);
                this.currentRange = nextLowestRange;
                return range;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private long[][] convertState() {
            long[][] labelIdsByNodeIndex = new long[64][];
            for (int i = 0; i < 64; ++i) {
                List<Long> labelIdList = this.labelsForEachNode[i];
                if (labelIdList == null) continue;
                labelIdsByNodeIndex[i] = PrimitiveLongCollections.asArray(labelIdList.iterator());
            }
            return labelIdsByNodeIndex;
        }

        private int readRange(int slots, RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor) {
            for (long bits = ((LabelScanValue)((Hit)cursor.get()).value()).bits; bits != 0L; bits &= bits - 1L) {
                int relativeNodeId = Long.numberOfTrailingZeros(bits);
                long labelId = ((LabelScanKey)((Hit)cursor.get()).key()).labelId;
                if (this.labelsForEachNode[relativeNodeId] == null) {
                    this.labelsForEachNode[relativeNodeId] = new ArrayList<Long>();
                    ++slots;
                }
                this.labelsForEachNode[relativeNodeId].add(labelId);
            }
            return slots;
        }
    }
}

