/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.constraints;

import java.util.Iterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.api.schema.RelationshipPropertyDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintBoundary;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class StandardConstraintSemantics
implements ConstraintSemantics {
    public static final String ERROR_MESSAGE = "Property existence constraint requires Neo4j Enterprise Edition";

    @Override
    public void validateNodePropertyExistenceConstraint(Iterator<Cursor<NodeItem>> allNodes, NodePropertyDescriptor descriptor) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(new NodePropertyExistenceConstraint(descriptor));
    }

    @Override
    public void validateRelationshipPropertyExistenceConstraint(Cursor<RelationshipItem> allRels, RelationshipPropertyDescriptor descriptor) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(new RelationshipPropertyExistenceConstraint(descriptor));
    }

    @Override
    public PropertyConstraint readConstraint(ConstraintRule rule) {
        ConstraintDescriptor desc = rule.getConstraintDescriptor();
        if (desc.type() == ConstraintDescriptor.Type.UNIQUE) {
            return ConstraintBoundary.map(desc);
        }
        return this.readNonStandardConstraint(rule);
    }

    protected PropertyConstraint readNonStandardConstraint(ConstraintRule rule) {
        throw new IllegalStateException(ERROR_MESSAGE);
    }

    private CreateConstraintFailureException propertyExistenceConstraintsNotAllowed(PropertyConstraint constraint) {
        return new CreateConstraintFailureException(constraint, (Throwable)new IllegalStateException(ERROR_MESSAGE));
    }

    @Override
    public ConstraintRule writeUniquePropertyConstraint(long ruleId, NodePropertyDescriptor descriptor, long indexId) {
        return ConstraintRule.constraintRule(ruleId, ConstraintDescriptorFactory.uniqueForLabel(descriptor.getLabelId(), descriptor.getPropertyKeyId()), indexId);
    }

    @Override
    public ConstraintRule writeNodePropertyExistenceConstraint(long ruleId, NodePropertyDescriptor descriptor) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(new NodePropertyExistenceConstraint(descriptor));
    }

    @Override
    public ConstraintRule writeRelationshipPropertyExistenceConstraint(long ruleId, RelationshipPropertyDescriptor descriptor) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(new RelationshipPropertyExistenceConstraint(descriptor));
    }

    @Override
    public TxStateVisitor decorateTxStateVisitor(StoreReadLayer storeLayer, ReadableTransactionState txState, TxStateVisitor visitor) {
        return visitor;
    }
}

