/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.ConnectorValidator;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.configuration.Settings;

public class HttpConnectorValidator
extends ConnectorValidator {
    private static final Consumer<String> nullConsumer = s -> {};

    public HttpConnectorValidator() {
        super(Connector.ConnectorType.HTTP);
    }

    @Override
    @Nonnull
    protected Optional<Setting> getSettingFor(@Nonnull String settingName, @Nonnull Map<String, String> params) {
        String subsetting;
        String[] parts = settingName.split("\\.");
        String name = parts[2];
        switch (subsetting = parts[3]) {
            case "encryption": {
                return Optional.of(HttpConnectorValidator.encryptionSetting(name));
            }
            case "address": 
            case "listen_address": {
                return Optional.of(Settings.listenAddress(settingName, this.defaultPort(name, params)));
            }
            case "advertised_address": {
                return Optional.of(Settings.advertisedAddress(settingName, Settings.listenAddress(settingName, this.defaultPort(name, params))));
            }
        }
        return super.getSettingFor(settingName, params);
    }

    private int defaultPort(@Nonnull String name, @Nonnull Map<String, String> rawConfig) {
        switch (name) {
            case "http": {
                return HttpConnector.Encryption.NONE.defaultPort;
            }
            case "https": {
                return HttpConnector.Encryption.TLS.defaultPort;
            }
        }
        Setting<HttpConnector.Encryption> es = HttpConnectorValidator.encryptionSetting(name);
        return ((HttpConnector.Encryption)((Object)es.apply((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Ljava/lang/String;)Ljava/lang/String;)(rawConfig)))).defaultPort;
    }

    @Nonnull
    private static Map<String, String> assertEncryption(@Nonnull String name, @Nonnull Setting<?> setting, @Nonnull Map<String, String> rawConfig) {
        Map result = setting.validate(rawConfig, nullConsumer);
        Optional<Object> encryption = Optional.ofNullable(setting.apply(rawConfig::get));
        if ("https".equalsIgnoreCase(name)) {
            if (encryption.isPresent() && !HttpConnector.Encryption.TLS.equals(encryption.get())) {
                throw new InvalidSettingException(String.format("'%s' is only allowed to be '%s'; not '%s'", setting.name(), HttpConnector.Encryption.TLS.name(), encryption.get()));
            }
        } else if ("http".equalsIgnoreCase(name) && encryption.isPresent() && !HttpConnector.Encryption.NONE.equals(encryption.get())) {
            throw new InvalidSettingException(String.format("'%s' is only allowed to be '%s'; not '%s'", setting.name(), HttpConnector.Encryption.NONE.name(), encryption.get()));
        }
        return result;
    }

    @Nonnull
    public static Setting<HttpConnector.Encryption> encryptionSetting(@Nonnull String name) {
        return HttpConnectorValidator.encryptionSetting(name, HttpConnector.Encryption.NONE);
    }

    @Nonnull
    public static Setting<HttpConnector.Encryption> encryptionSetting(final @Nonnull String name, HttpConnector.Encryption defaultValue) {
        final Setting<HttpConnector.Encryption> s = Settings.setting("dbms.connector." + name + ".encryption", Settings.options(HttpConnector.Encryption.class), defaultValue.name());
        return new Setting<HttpConnector.Encryption>(){

            public String name() {
                return s.name();
            }

            public void withScope(Function<String, String> scopingRule) {
                s.withScope(scopingRule);
            }

            public String getDefaultValue() {
                return s.getDefaultValue();
            }

            public HttpConnector.Encryption from(Configuration config) {
                return (HttpConnector.Encryption)((Object)s.from(config));
            }

            public HttpConnector.Encryption apply(Function<String, String> stringStringFunction) {
                return (HttpConnector.Encryption)((Object)s.apply(stringStringFunction));
            }

            public Map<String, String> validate(Map<String, String> rawConfig, Consumer<String> warningConsumer) throws InvalidSettingException {
                Map result = s.validate(rawConfig, warningConsumer);
                HttpConnectorValidator.assertEncryption(name, s, rawConfig);
                return result;
            }
        };
    }
}

