/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import org.neo4j.configuration.Description;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Configuration options for Bolt connectors. \"(bolt-connector-key)\" is a placeholder for a unique name for the connector, for instance \"bolt-public\" or some other name that describes what the connector is for.")
public class BoltConnector
extends Connector {
    @Description(value="Encryption level to require this connector to use")
    public final Setting<EncryptionLevel> encryption_level;
    @Description(value="Address the connector should bind to. This setting is deprecated and will be replaced by `+listen_address+`")
    public final Setting<ListenSocketAddress> address;
    @Description(value="Address the connector should bind to")
    public final Setting<ListenSocketAddress> listen_address;
    @Description(value="Advertised address for this connector")
    public final Setting<AdvertisedSocketAddress> advertised_address;

    public BoltConnector() {
        this("(bolt-connector-key)");
    }

    public BoltConnector(String key) {
        super(key);
        this.encryption_level = this.group.scope(Settings.setting("tls_level", Settings.options(EncryptionLevel.class), EncryptionLevel.OPTIONAL.name()));
        Setting<ListenSocketAddress> legacyAddressSetting = Settings.listenAddress("address", 7687);
        Setting<ListenSocketAddress> listenAddressSetting = Settings.legacyFallback(legacyAddressSetting, Settings.listenAddress("listen_address", 7687));
        this.address = this.group.scope(legacyAddressSetting);
        this.listen_address = this.group.scope(listenAddressSetting);
        this.advertised_address = this.group.scope(Settings.advertisedAddress("advertised_address", listenAddressSetting));
    }

    public static enum EncryptionLevel {
        REQUIRED,
        OPTIONAL,
        DISABLED;

    }
}

