/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new.index;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;

public class NewIndexDescriptor {
    private final LabelSchemaDescriptor schema;
    private final Type type;

    NewIndexDescriptor(LabelSchemaDescriptor schema, Type type) {
        this.schema = schema;
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    public LabelSchemaDescriptor schema() {
        return this.schema;
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format("Index( %s, %s )", this.type.name(), this.schema.userDescription(tokenNameLookup));
    }

    public boolean isSame(Supplier supplier) {
        return this.equals(supplier.getNewIndexDescriptor());
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof NewIndexDescriptor) {
            NewIndexDescriptor that = (NewIndexDescriptor)o;
            return this.type() == that.type() && this.schema().equals(that.schema());
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() & this.schema.hashCode();
    }

    public static interface Supplier {
        public NewIndexDescriptor getNewIndexDescriptor();
    }

    public static enum Type {
        GENERAL,
        UNIQUE;

    }
}

