/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.storageengine.api.EntityType;

public abstract class EntityPropertyDescriptor
implements Comparable<EntityPropertyDescriptor> {
    protected final int entityId;
    private final int propertyKeyId;

    public EntityPropertyDescriptor(int entityId, int propertyKeyId) {
        this.entityId = entityId;
        this.propertyKeyId = propertyKeyId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof EntityPropertyDescriptor) {
            EntityPropertyDescriptor that = (EntityPropertyDescriptor)obj;
            return this.entityId == that.entityId && this.propertyKeyId == that.propertyKeyId;
        }
        return false;
    }

    public int hashCode() {
        int result = this.entityId;
        result = 31 * result + this.propertyKeyId;
        return result;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getPropertyKeyId() {
        return this.propertyKeyId;
    }

    public int[] getPropertyKeyIds() {
        throw new UnsupportedOperationException("Cannot get multiple property Ids of single property descriptor");
    }

    public String toString() {
        return String.format(":%s[%d](property[%d])", this.entityType().getLabelingType(), this.entityId, this.propertyKeyId);
    }

    public String propertyIdText() {
        return Integer.toString(this.propertyKeyId);
    }

    public abstract EntityType entityType();

    public abstract String entityNameText(TokenNameLookup var1);

    public String propertyNameText(TokenNameLookup tokenNameLookup) {
        return tokenNameLookup.propertyKeyGetName(this.propertyKeyId);
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format(":%s(%s)", this.entityNameText(tokenNameLookup), this.propertyNameText(tokenNameLookup));
    }

    @Override
    public int compareTo(EntityPropertyDescriptor that) {
        int cmp = this.entityId - that.entityId;
        if (cmp == 0) {
            return this.propertyKeyId - that.propertyKeyId;
        }
        return cmp;
    }
}

