/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.proc.FieldSignature;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.QualifiedName;

public class UserFunctionSignature {
    private final QualifiedName name;
    private final List<FieldSignature> inputSignature;
    private final Neo4jTypes.AnyType type;
    private final String[] allowed;
    private final Optional<String> deprecated;
    private final Optional<String> description;

    public UserFunctionSignature(QualifiedName name, List<FieldSignature> inputSignature, Neo4jTypes.AnyType type, Optional<String> deprecated, String[] allowed, Optional<String> description) {
        this.name = name;
        this.inputSignature = Collections.unmodifiableList(inputSignature);
        this.type = type;
        this.deprecated = deprecated;
        this.description = description;
        this.allowed = allowed;
    }

    public QualifiedName name() {
        return this.name;
    }

    public Optional<String> deprecated() {
        return this.deprecated;
    }

    public List<FieldSignature> inputSignature() {
        return this.inputSignature;
    }

    public Neo4jTypes.AnyType outputType() {
        return this.type;
    }

    public Optional<String> description() {
        return this.description;
    }

    public String[] allowed() {
        return this.allowed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFunctionSignature that = (UserFunctionSignature)o;
        return this.name.equals(that.name) && this.inputSignature.equals(that.inputSignature) && this.type.equals(that.type);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String strInSig = this.inputSignature == null ? "..." : Iterables.toString(this.inputSignature, (String)", ");
        String strOutSig = this.type == null ? "..." : this.type.toString();
        return String.format("%s(%s) :: (%s)", this.name, strInSig, strOutSig);
    }

    public static Builder functionSignature(String ... namespaceAndName) {
        String[] namespace = namespaceAndName.length > 1 ? Arrays.copyOf(namespaceAndName, namespaceAndName.length - 1) : new String[]{};
        String name = namespaceAndName[namespaceAndName.length - 1];
        return UserFunctionSignature.functionSignature(namespace, name);
    }

    public static Builder functionSignature(QualifiedName name) {
        return new Builder(name.namespace(), name.name());
    }

    public static Builder functionSignature(String[] namespace, String name) {
        return new Builder(namespace, name);
    }

    public static QualifiedName procedureName(String ... namespaceAndName) {
        return UserFunctionSignature.functionSignature(namespaceAndName).build().name();
    }

    public static class Builder {
        private final QualifiedName name;
        private final List<FieldSignature> inputSignature = new LinkedList<FieldSignature>();
        private Neo4jTypes.AnyType outputType;
        private String[] allowed = new String[0];
        private Optional<String> deprecated = Optional.empty();
        private Optional<String> description = Optional.empty();

        public Builder(String[] namespace, String name) {
            this.name = new QualifiedName(namespace, name);
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        public Builder deprecatedBy(String deprecated) {
            this.deprecated = Optional.of(deprecated);
            return this;
        }

        public Builder in(String name, Neo4jTypes.AnyType type) {
            this.inputSignature.add(new FieldSignature(name, type));
            return this;
        }

        public Builder out(Neo4jTypes.AnyType type) {
            this.outputType = type;
            return this;
        }

        public Builder allowed(String[] allowed) {
            this.allowed = allowed;
            return this;
        }

        public UserFunctionSignature build() {
            if (this.outputType == null) {
                throw new IllegalStateException("output type must be set");
            }
            return new UserFunctionSignature(this.name, this.inputSignature, this.outputType, this.deprecated, this.allowed, this.description);
        }
    }
}

