/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.ConstraintViolationKernelException;
import org.neo4j.kernel.api.schema.RelationshipPropertyDescriptor;

public class RelationshipPropertyExistenceConstraintViolationKernelException
extends ConstraintViolationKernelException {
    private final RelationshipPropertyDescriptor descriptor;
    private final long relationshipId;

    public RelationshipPropertyExistenceConstraintViolationKernelException(RelationshipPropertyDescriptor descriptor, long relationshipId) {
        super("Relationship %d with type %d must have the property %d", relationshipId, descriptor.getRelationshipTypeId(), descriptor.getPropertyKeyId());
        this.descriptor = descriptor;
        this.relationshipId = relationshipId;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Relationship %d with type \"%s\" must have the property \"%s\" due to a constraint", this.relationshipId, tokenNameLookup.relationshipTypeGetName(this.descriptor.getRelationshipTypeId()), tokenNameLookup.propertyKeyGetName(this.descriptor.getPropertyKeyId()));
    }
}

