/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;

public class IndexBelongsToConstraintException
extends SchemaKernelException {
    private final NodePropertyDescriptor index;
    private static final String message = "Index belongs to constraint: %s";

    public IndexBelongsToConstraintException(NodePropertyDescriptor index) {
        super((Status)Status.Schema.ForbiddenOnConstraintIndex, String.format(message, index));
        this.index = index;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format(message, this.index.userDescription(tokenNameLookup));
    }
}

