/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.constraints;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;

public class NodePropertyExistenceConstraint
extends NodePropertyConstraint {
    public NodePropertyExistenceConstraint(NodePropertyDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    public void added(PropertyConstraint.ChangeVisitor visitor) throws CreateConstraintFailureException {
        visitor.visitAddedNodePropertyExistenceConstraint(this);
    }

    @Override
    public void removed(PropertyConstraint.ChangeVisitor visitor) {
        visitor.visitRemovedNodePropertyExistenceConstraint(this);
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        String labelName = this.labelName(tokenNameLookup);
        String boundIdentifier = labelName.toLowerCase();
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT exists(%s.%s)", boundIdentifier, labelName, boundIdentifier, this.descriptor.propertyNameText(tokenNameLookup));
    }

    @Override
    public String toString() {
        return String.format("CONSTRAINT ON ( n:label[%s] ) ASSERT exists(n.property[%s])", this.descriptor.getLabelId(), this.descriptor.propertyIdText());
    }
}

