/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.time.SystemNanoClock;

abstract class ExecutingQueryStatus {
    ExecutingQueryStatus() {
    }

    abstract long waitTimeNanos(SystemNanoClock var1);

    abstract Map<String, Object> toMap(SystemNanoClock var1);

    static ExecutingQueryStatus planning() {
        return SimpleState.PLANNING;
    }

    static ExecutingQueryStatus running() {
        return SimpleState.RUNNING;
    }

    abstract boolean isPlanning();

    private static final class SimpleState
    extends ExecutingQueryStatus {
        static final ExecutingQueryStatus PLANNING = new SimpleState("PLANNING", true);
        static final ExecutingQueryStatus RUNNING = new SimpleState("RUNNING", false);
        private final Map<String, Object> state;
        private final boolean planning;

        private SimpleState(String state, boolean planning) {
            this(Collections.singletonMap("state", state), planning);
        }

        private SimpleState(Map<String, Object> state, boolean planning) {
            this.state = Collections.unmodifiableMap(state);
            this.planning = planning;
        }

        @Override
        long waitTimeNanos(SystemNanoClock clock) {
            return 0L;
        }

        @Override
        Map<String, Object> toMap(SystemNanoClock clock) {
            return this.state;
        }

        @Override
        boolean isPlanning() {
            return this.planning;
        }
    }

    static class WaitingOnLock
    extends ExecutingQueryStatus {
        private final String mode;
        private final ResourceType resourceType;
        private final long[] resourceIds;
        private final long startTimeNanos;

        WaitingOnLock(String mode, ResourceType resourceType, long[] resourceIds, long startTimeNanos) {
            this.mode = mode;
            this.resourceType = resourceType;
            this.resourceIds = resourceIds;
            this.startTimeNanos = startTimeNanos;
        }

        @Override
        long waitTimeNanos(SystemNanoClock clock) {
            return clock.nanos() - this.startTimeNanos;
        }

        @Override
        Map<String, Object> toMap(SystemNanoClock clock) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("state", "WAITING");
            map.put("lockMode", this.mode);
            map.put("waitTimeMillis", TimeUnit.NANOSECONDS.toMillis(this.waitTimeNanos(clock)));
            map.put("resourceType", this.resourceType.toString());
            map.put("resourceIds", this.resourceIds);
            return map;
        }

        @Override
        boolean isPlanning() {
            return false;
        }
    }
}

