/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.kernel.api.ExecutingQueryStatus;
import org.neo4j.kernel.api.IndexUsage;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockWaitEvent;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.time.CpuClock;
import org.neo4j.time.SystemNanoClock;

public class ExecutingQuery {
    private static final AtomicLongFieldUpdater<ExecutingQuery> WAIT_TIME = AtomicLongFieldUpdater.newUpdater(ExecutingQuery.class, "waitTimeNanos");
    private final long queryId;
    private final LockTracer lockTracer = this::waitForLock;
    private final String username;
    private final ClientConnectionInfo clientConnection;
    private final String queryText;
    private final Map<String, Object> queryParameters;
    private final long startTime;
    private long planningDone;
    private final Thread threadExecutingTheQuery;
    private final LongSupplier activeLockCount;
    private final SystemNanoClock clock;
    private final CpuClock cpuClock;
    private final long cpuTimeNanosWhenQueryStarted;
    private final Map<String, Object> metaData;
    private PlannerInfo plannerInfo;
    private volatile ExecutingQueryStatus status = ExecutingQueryStatus.planning();
    private volatile long waitTimeNanos;

    public ExecutingQuery(long queryId, ClientConnectionInfo clientConnection, String username, String queryText, Map<String, Object> queryParameters, Map<String, Object> metaData, LongSupplier activeLockCount, Thread threadExecutingTheQuery, SystemNanoClock clock, CpuClock cpuClock) {
        this.queryId = queryId;
        this.clientConnection = clientConnection;
        this.username = username;
        this.queryText = queryText;
        this.queryParameters = queryParameters;
        this.activeLockCount = activeLockCount;
        this.clock = clock;
        this.startTime = clock.millis();
        this.metaData = metaData;
        this.threadExecutingTheQuery = threadExecutingTheQuery;
        this.cpuClock = cpuClock;
        this.cpuTimeNanosWhenQueryStarted = cpuClock.cpuTimeNanos(threadExecutingTheQuery);
    }

    public void planningCompleted(PlannerInfo plannerInfo) {
        this.plannerInfo = plannerInfo;
        this.planningDone = this.clock.millis();
        this.status = ExecutingQueryStatus.running();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutingQuery that = (ExecutingQuery)o;
        return this.queryId == that.queryId;
    }

    public int hashCode() {
        return (int)(this.queryId ^ this.queryId >>> 32);
    }

    public long internalQueryId() {
        return this.queryId;
    }

    public String username() {
        return this.username;
    }

    public ClientConnectionInfo clientConnection() {
        return this.clientConnection;
    }

    public QueryInfo query() {
        return this.status.isPlanning() ? new QueryInfo(this.queryText, this.queryParameters, null) : new QueryInfo(this.queryText, this.queryParameters, this.plannerInfo);
    }

    public String queryText() {
        return this.queryText;
    }

    public Map<String, Object> queryParameters() {
        return this.queryParameters;
    }

    public long startTime() {
        return this.startTime;
    }

    public long planningTimeMillis() {
        if (this.status.isPlanning()) {
            return this.elapsedTimeMillis();
        }
        return this.planningDone - this.startTime;
    }

    public long elapsedTimeMillis() {
        return this.clock.millis() - this.startTime;
    }

    public long cpuTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.cpuClock.cpuTimeNanos(this.threadExecutingTheQuery) - this.cpuTimeNanosWhenQueryStarted);
    }

    public long waitTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.waitTimeNanos + this.status.waitTimeNanos(this.clock));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public Map<String, Object> metaData() {
        return this.metaData;
    }

    public LockTracer lockTracer() {
        return this.lockTracer;
    }

    public long activeLockCount() {
        return this.activeLockCount.getAsLong();
    }

    public Map<String, Object> status() {
        return this.status.toMap(this.clock);
    }

    public String connectionDetailsForLogging() {
        return this.clientConnection.asConnectionDetails();
    }

    private LockWaitEvent waitForLock(boolean exclusive, ResourceType resourceType, long[] resourceIds) {
        WaitingOnLockEvent event = new WaitingOnLockEvent(exclusive ? "EXCLUSIVE" : "SHARED", resourceType, resourceIds);
        this.status = event;
        return event;
    }

    private class WaitingOnLockEvent
    extends ExecutingQueryStatus.WaitingOnLock
    implements LockWaitEvent {
        private final ExecutingQueryStatus previous;

        WaitingOnLockEvent(String mode, ResourceType resourceType, long[] resourceIds) {
            super(mode, resourceType, resourceIds, ExecutingQuery.this.clock.nanos());
            this.previous = ExecutingQuery.this.status;
        }

        @Override
        public void close() {
            if (ExecutingQuery.this.status != this) {
                return;
            }
            WAIT_TIME.addAndGet(ExecutingQuery.this, this.waitTimeNanos(ExecutingQuery.this.clock));
            ExecutingQuery.this.status = this.previous;
        }

        @Override
        boolean isPlanning() {
            return this.previous.isPlanning();
        }
    }

    public static class PlannerInfo {
        final String planner;
        final String runtime;
        final List<IndexUsage> indexes;

        public PlannerInfo(String planner, String runtime, List<IndexUsage> indexes) {
            this.planner = planner;
            this.runtime = runtime;
            this.indexes = indexes;
        }
    }

    public static class QueryInfo {
        public final String text;
        public final Map<String, Object> parameters;
        public final String planner;
        public final String runtime;
        private final List<IndexUsage> indexes;

        private QueryInfo(String text, Map<String, Object> parameters, PlannerInfo plannerInfo) {
            this.text = text;
            this.parameters = parameters;
            if (plannerInfo != null) {
                this.planner = plannerInfo.planner;
                this.runtime = plannerInfo.runtime;
                this.indexes = plannerInfo.indexes;
            } else {
                this.planner = null;
                this.runtime = null;
                this.indexes = Collections.emptyList();
            }
        }

        public List<Map<String, String>> indexes() {
            ArrayList<Map<String, String>> used = new ArrayList<Map<String, String>>(this.indexes.size());
            for (IndexUsage index : this.indexes) {
                used.add(index.asMap());
            }
            return used;
        }
    }
}

