/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.schema.EntityPropertyDescriptor;

public interface SchemaRule {
    public long getId();

    public int getLabel();

    public int getRelationshipType();

    public EntityPropertyDescriptor descriptor();

    public Kind getKind();

    public static enum Kind {
        INDEX_RULE(true, false),
        CONSTRAINT_INDEX_RULE(true, true),
        UNIQUENESS_CONSTRAINT(false, true),
        NODE_PROPERTY_EXISTENCE_CONSTRAINT(false, true),
        RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT(false, true);

        private static final Kind[] ALL;
        private final boolean isIndex;
        private final boolean isConstraint;

        private Kind(boolean isIndex, boolean isConstraint) {
            this.isIndex = isIndex;
            this.isConstraint = isConstraint;
        }

        public byte id() {
            return (byte)(this.ordinal() + 1);
        }

        public boolean isConstraint() {
            return this.isConstraint;
        }

        public boolean isIndex() {
            return this.isIndex;
        }

        public static Kind forId(byte id) throws MalformedSchemaRuleException {
            if (id >= 1 && id <= ALL.length) {
                return Kind.values()[id - 1];
            }
            throw new MalformedSchemaRuleException(null, "Unknown kind id %d", new Object[]{id});
        }

        static {
            ALL = Kind.values();
        }
    }
}

