/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.logging.Log;

public class LoggingLogFileMonitor
implements PhysicalLogFile.Monitor,
LogRotation.Monitor,
Recovery.Monitor {
    private long firstTransactionRecovered = -1L;
    private long lastTransactionRecovered;
    private final Log log;

    public LoggingLogFileMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void recoveryRequired(LogPosition startPosition) {
        this.log.info("Recovery required from position " + startPosition);
    }

    @Override
    public void recoveryCompleted(int numberOfRecoveredTransactions) {
        if (numberOfRecoveredTransactions != 0) {
            this.log.info(String.format("Recovery completed. %d transactions, first:%d, last:%d recovered", numberOfRecoveredTransactions, this.firstTransactionRecovered, this.lastTransactionRecovered));
        } else {
            this.log.info("No recovery required");
        }
    }

    @Override
    public void startedRotating(long currentVersion) {
        this.log.info(String.format("Rotating log version:%d", currentVersion));
    }

    @Override
    public void finishedRotating(long currentVersion) {
        this.log.info(String.format("Finished rotating log version:%d", currentVersion));
    }

    @Override
    public void transactionRecovered(long txId) {
        if (this.firstTransactionRecovered == -1L) {
            this.firstTransactionRecovered = txId;
        }
        this.lastTransactionRecovered = txId;
    }

    @Override
    public void opened(File logFile, long logVersion, long lastTransactionId, boolean clean) {
        this.log.info(String.format("Opened logical log [%s] version=%d, lastTxId=%d (%s)", logFile, logVersion, lastTransactionId, clean ? "clean" : "recovered"));
    }
}

