/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.schema.NodeMultiPropertyDescriptor;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.impl.store.record.NodePropertyConstraintRule;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class UniquePropertyConstraintRule
extends NodePropertyConstraintRule {
    private final long ownedIndexRule;

    public static UniquePropertyConstraintRule uniquenessConstraintRule(long id, NodePropertyDescriptor descriptor, long ownedIndexRule) {
        return new UniquePropertyConstraintRule(id, descriptor, ownedIndexRule);
    }

    public static UniquePropertyConstraintRule readUniquenessConstraintRule(long id, int labelId, ByteBuffer buffer) {
        return new UniquePropertyConstraintRule(id, UniquePropertyConstraintRule.readDescriptor(labelId, buffer), UniquePropertyConstraintRule.readOwnedIndexRule(buffer));
    }

    private UniquePropertyConstraintRule(long id, NodePropertyDescriptor descriptor, long ownedIndexRule) {
        super(id, descriptor, SchemaRule.Kind.UNIQUENESS_CONSTRAINT);
        this.ownedIndexRule = ownedIndexRule;
        assert (!descriptor.isComposite());
    }

    @Override
    public String toString() {
        return "UniquePropertyConstraintRule[id=" + this.id + ", label=" + this.descriptor().getLabelId() + ", kind=" + (Object)((Object)this.kind) + ", propertyKeys=" + this.descriptor.propertyIdText() + ", ownedIndex=" + this.ownedIndexRule + "]";
    }

    @Override
    public int length() {
        int propertyCount = this.descriptor().isComposite() ? this.descriptor.getPropertyKeyIds().length : 1;
        return 6 + 8 * propertyCount + 8;
    }

    @Override
    public void serialize(ByteBuffer target) {
        int[] nArray;
        if (this.descriptor().isComposite()) {
            nArray = this.descriptor.getPropertyKeyIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.descriptor.getPropertyKeyId();
        }
        int[] propertyKeyIds = nArray;
        target.putInt(this.descriptor().getLabelId());
        target.put(this.kind.id());
        target.put((byte)propertyKeyIds.length);
        for (int propertyKeyId : propertyKeyIds) {
            target.putLong(propertyKeyId);
        }
        target.putLong(this.ownedIndexRule);
    }

    private static NodePropertyDescriptor readDescriptor(int labelId, ByteBuffer buffer) {
        int[] keys = new int[buffer.get()];
        if (keys.length > 1) {
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = IoPrimitiveUtils.safeCastLongToInt(buffer.getLong());
            }
            return new NodeMultiPropertyDescriptor(labelId, keys);
        }
        return new NodePropertyDescriptor(labelId, IoPrimitiveUtils.safeCastLongToInt(buffer.getLong()));
    }

    private static long readOwnedIndexRule(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public long getOwnedIndex() {
        return this.ownedIndexRule;
    }

    @Override
    public UniquenessConstraint toConstraint() {
        return new UniquenessConstraint(this.descriptor());
    }
}

