/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.schema.RelationshipPropertyDescriptor;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyConstraintRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class RelationshipPropertyExistenceConstraintRule
extends RelationshipPropertyConstraintRule {
    public static RelationshipPropertyExistenceConstraintRule relPropertyExistenceConstraintRule(long id, RelationshipPropertyDescriptor descriptor) {
        return new RelationshipPropertyExistenceConstraintRule(id, descriptor);
    }

    public static RelationshipPropertyExistenceConstraintRule readRelPropertyExistenceConstraintRule(long id, int relTypeId, ByteBuffer buffer) {
        return new RelationshipPropertyExistenceConstraintRule(id, new RelationshipPropertyDescriptor(relTypeId, RelationshipPropertyExistenceConstraintRule.readPropertyKey(buffer)));
    }

    private RelationshipPropertyExistenceConstraintRule(long id, RelationshipPropertyDescriptor descriptor) {
        super(id, descriptor, SchemaRule.Kind.RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT);
    }

    @Override
    public String toString() {
        return "RelationshipPropertyExistenceConstraint" + this.id + ", relationshipType=" + this.getRelationshipType() + ", kind=" + (Object)((Object)this.kind) + ", propertyKeyId=" + this.descriptor.propertyIdText() + "]";
    }

    @Override
    public int length() {
        return 9;
    }

    @Override
    public void serialize(ByteBuffer target) {
        target.putInt(this.getRelationshipType());
        target.put(this.kind.id());
        target.putInt(this.descriptor.getPropertyKeyId());
    }

    private static int readPropertyKey(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public int getPropertyKey() {
        return this.descriptor.getPropertyKeyId();
    }

    @Override
    public RelationshipPropertyConstraint toConstraint() {
        return new RelationshipPropertyExistenceConstraint(this.descriptor());
    }
}

