/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.impl.store.record.NodePropertyConstraintRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class NodePropertyExistenceConstraintRule
extends NodePropertyConstraintRule {
    public static NodePropertyExistenceConstraintRule nodePropertyExistenceConstraintRule(long id, NodePropertyDescriptor descriptor) {
        return new NodePropertyExistenceConstraintRule(id, descriptor);
    }

    public static NodePropertyExistenceConstraintRule readNodePropertyExistenceConstraintRule(long id, int labelId, ByteBuffer buffer) {
        return new NodePropertyExistenceConstraintRule(id, new NodePropertyDescriptor(labelId, buffer.getInt()));
    }

    private NodePropertyExistenceConstraintRule(long id, NodePropertyDescriptor descriptor) {
        super(id, descriptor, SchemaRule.Kind.NODE_PROPERTY_EXISTENCE_CONSTRAINT);
    }

    @Override
    public String toString() {
        return "NodePropertyExistenceConstraintRule[id=" + this.id + ", label=" + this.descriptor().getLabelId() + ", kind=" + (Object)((Object)this.kind) + ", propertyKeyIds=" + this.descriptor.propertyIdText() + "]";
    }

    @Override
    public int length() {
        return 9;
    }

    @Override
    public void serialize(ByteBuffer target) {
        target.putInt(this.descriptor().getLabelId());
        target.put(this.kind.id());
        target.putInt(this.descriptor.getPropertyKeyId());
    }

    @Override
    public NodePropertyConstraint toConstraint() {
        return new NodePropertyExistenceConstraint(this.descriptor());
    }
}

