/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.IndexDescriptorFactory;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.impl.store.record.AbstractSchemaRule;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.schema.IndexSchemaRule;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.string.UTF8;

public class IndexRule
extends AbstractSchemaRule
implements IndexSchemaRule {
    private static final long NO_OWNING_CONSTRAINT = -1L;
    private final SchemaIndexProvider.Descriptor providerDescriptor;
    private final Long owningConstraint;

    static IndexRule readIndexRule(long id, boolean constraintIndex, int label, ByteBuffer serialized) {
        SchemaIndexProvider.Descriptor providerDescriptor = IndexRule.readProviderDescriptor(serialized);
        NodePropertyDescriptor descriptor = IndexDescriptorFactory.getNodePropertyDescriptor(label, IndexRule.readPropertyKeys(serialized));
        if (constraintIndex) {
            long owningConstraint = IndexRule.readOwningConstraint(serialized);
            return IndexRule.constraintIndexRule(id, descriptor, providerDescriptor, owningConstraint);
        }
        return IndexRule.indexRule(id, descriptor, providerDescriptor);
    }

    public static IndexRule indexRule(long id, NodePropertyDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor) {
        return new IndexRule(id, descriptor, providerDescriptor, null);
    }

    public static IndexRule constraintIndexRule(long id, NodePropertyDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, Long owningConstraint) {
        return new IndexRule(id, descriptor, providerDescriptor, owningConstraint == null ? -1L : owningConstraint);
    }

    public IndexRule(long id, NodePropertyDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, Long owningConstraint) {
        super(id, IndexRule.indexKind(owningConstraint), descriptor);
        this.owningConstraint = owningConstraint;
        if (providerDescriptor == null) {
            throw new IllegalArgumentException("null provider descriptor prohibited");
        }
        this.providerDescriptor = providerDescriptor;
    }

    private static SchemaRule.Kind indexKind(Long owningConstraint) {
        return owningConstraint == null ? SchemaRule.Kind.INDEX_RULE : SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
    }

    private static SchemaIndexProvider.Descriptor readProviderDescriptor(ByteBuffer serialized) {
        String providerKey = UTF8.getDecodedStringFrom((ByteBuffer)serialized);
        String providerVersion = UTF8.getDecodedStringFrom((ByteBuffer)serialized);
        return new SchemaIndexProvider.Descriptor(providerKey, providerVersion);
    }

    private static int[] readPropertyKeys(ByteBuffer serialized) {
        int count = serialized.getShort();
        assert (count >= 1);
        int[] props = new int[count];
        for (int i = 0; i < count; ++i) {
            props[i] = IoPrimitiveUtils.safeCastLongToInt(serialized.getLong());
        }
        return props;
    }

    private static long readOwningConstraint(ByteBuffer serialized) {
        return serialized.getLong();
    }

    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public NodePropertyDescriptor descriptor() {
        return (NodePropertyDescriptor)this.descriptor;
    }

    @Override
    public boolean isConstraintIndex() {
        return this.owningConstraint != null;
    }

    @Override
    public Long getOwningConstraint() {
        if (!this.isConstraintIndex()) {
            throw new IllegalStateException("Can only get owner from constraint indexes.");
        }
        long owningConstraint = this.owningConstraint;
        if (owningConstraint == -1L) {
            return null;
        }
        return owningConstraint;
    }

    @Override
    public int getLabel() {
        return this.descriptor().getLabelId();
    }

    @Override
    public int getRelationshipType() {
        throw new IllegalStateException("Index rule is associated with nodes");
    }

    @Override
    public int length() {
        int propertyCount = this.descriptor().isComposite() ? this.descriptor.getPropertyKeyIds().length : 1;
        return 5 + UTF8.computeRequiredByteBufferSize((String)this.providerDescriptor.getKey()) + UTF8.computeRequiredByteBufferSize((String)this.providerDescriptor.getVersion()) + 2 + 8 * propertyCount + (this.isConstraintIndex() ? 8 : 0);
    }

    @Override
    public void serialize(ByteBuffer target) {
        int[] nArray;
        if (this.descriptor().isComposite()) {
            nArray = this.descriptor.getPropertyKeyIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.descriptor.getPropertyKeyId();
        }
        int[] propertyKeys = nArray;
        target.putInt(this.descriptor().getLabelId());
        target.put((byte)(this.kind.ordinal() + 1));
        UTF8.putEncodedStringInto((String)this.providerDescriptor.getKey(), (ByteBuffer)target);
        UTF8.putEncodedStringInto((String)this.providerDescriptor.getVersion(), (ByteBuffer)target);
        target.putShort((short)propertyKeys.length);
        for (int i = 0; i < propertyKeys.length; ++i) {
            target.putLong(propertyKeys[i]);
        }
        if (this.isConstraintIndex()) {
            target.putLong(this.owningConstraint);
        }
    }

    @Override
    public boolean matches(NodePropertyDescriptor descriptor) {
        return descriptor.equals(this.descriptor);
    }

    @Override
    public String toString() {
        String ownerString = "";
        if (this.owningConstraint != null) {
            ownerString = ", owner=" + (this.owningConstraint == -1L ? "<not set>" : this.owningConstraint);
        }
        return "IndexRule[id=" + this.id + ", label=" + this.descriptor().getLabelId() + ", kind=" + (Object)((Object)this.kind) + ", provider=" + this.providerDescriptor + ", properties=" + this.descriptor.propertyIdText() + ownerString + "]";
    }

    public IndexRule withOwningConstraint(long constraintId) {
        if (!this.isConstraintIndex()) {
            throw new IllegalStateException(this + " is not a constraint index");
        }
        return IndexRule.constraintIndexRule(this.getId(), this.descriptor(), this.getProviderDescriptor(), constraintId);
    }
}

