/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.schema.EntityPropertyDescriptor;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodePropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.RecordSerializable;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public abstract class AbstractSchemaRule
implements SchemaRule,
RecordSerializable {
    protected final SchemaRule.Kind kind;
    protected final long id;
    protected final EntityPropertyDescriptor descriptor;

    public AbstractSchemaRule(long id, SchemaRule.Kind kind, EntityPropertyDescriptor descriptor) {
        this.id = id;
        this.kind = kind;
        this.descriptor = descriptor;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public final SchemaRule.Kind getKind() {
        return this.kind;
    }

    @Override
    public abstract int length();

    @Override
    public abstract void serialize(ByteBuffer var1);

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof AbstractSchemaRule) {
            AbstractSchemaRule that = (AbstractSchemaRule)o;
            return this.kind == that.kind && this.descriptor.equals(that.descriptor());
        }
        return false;
    }

    public final int hashCode() {
        return 31 * this.kind.hashCode() + this.descriptor.hashCode();
    }

    public abstract String toString();

    public static SchemaRule deserialize(long id, ByteBuffer buffer) throws MalformedSchemaRuleException {
        int labelId = buffer.getInt();
        SchemaRule.Kind kind = SchemaRule.Kind.forId(buffer.get());
        try {
            SchemaRule rule = AbstractSchemaRule.newRule(kind, id, labelId, buffer);
            if (null == rule) {
                throw new MalformedSchemaRuleException(null, "Deserialized null schema rule for id %d with kind %s", new Object[]{id, kind.name()});
            }
            return rule;
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException(e, "Could not deserialize schema rule for id %d with kind %s", id, kind.name());
        }
    }

    protected static SchemaRule newRule(SchemaRule.Kind kind, long id, int labelId, ByteBuffer buffer) {
        switch (kind) {
            case INDEX_RULE: {
                return IndexRule.readIndexRule(id, false, labelId, buffer);
            }
            case CONSTRAINT_INDEX_RULE: {
                return IndexRule.readIndexRule(id, true, labelId, buffer);
            }
            case UNIQUENESS_CONSTRAINT: {
                return UniquePropertyConstraintRule.readUniquenessConstraintRule(id, labelId, buffer);
            }
            case NODE_PROPERTY_EXISTENCE_CONSTRAINT: {
                return NodePropertyExistenceConstraintRule.readNodePropertyExistenceConstraintRule(id, labelId, buffer);
            }
            case RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT: {
                return RelationshipPropertyExistenceConstraintRule.readRelPropertyExistenceConstraintRule(id, labelId, buffer);
            }
        }
        throw new IllegalArgumentException(kind.name());
    }

    public static Class<?> getRuleClass(SchemaRule.Kind kind) {
        switch (kind) {
            case INDEX_RULE: 
            case CONSTRAINT_INDEX_RULE: {
                return IndexRule.class;
            }
            case UNIQUENESS_CONSTRAINT: {
                return UniquePropertyConstraintRule.class;
            }
            case NODE_PROPERTY_EXISTENCE_CONSTRAINT: {
                return NodePropertyExistenceConstraintRule.class;
            }
            case RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT: {
                return RelationshipPropertyExistenceConstraintRule.class;
            }
        }
        throw new IllegalArgumentException(kind.name());
    }
}

