/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts.keys;

import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.util.IdPrettyPrinter;

abstract class IndexKey
implements CountsKey {
    private final IndexDescriptor descriptor;
    private final CountsKeyType type;

    IndexKey(IndexDescriptor descriptor, CountsKeyType type) {
        this.descriptor = descriptor;
        this.type = type;
    }

    public IndexDescriptor descriptor() {
        return this.descriptor;
    }

    public String toString() {
        String propertyText = this.descriptor.descriptor().propertyIdText();
        return String.format("IndexKey[%s (%s {%s})]", this.type.name(), IdPrettyPrinter.label(this.descriptor.getLabelId()), propertyText);
    }

    @Override
    public CountsKeyType recordType() {
        return this.type;
    }

    public int hashCode() {
        return 31 * this.descriptor.hashCode() + this.type.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IndexKey indexKey = (IndexKey)other;
        return indexKey.descriptor.equals(this.descriptor);
    }

    @Override
    public int compareTo(CountsKey other) {
        if (other instanceof IndexKey) {
            IndexKey that = (IndexKey)other;
            return this.descriptor.descriptor().compareTo(that.descriptor.descriptor());
        }
        return this.recordType().ordinal() - other.recordType().ordinal();
    }
}

