/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.IOException;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.ValueUpdate;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

final class CountsUpdater
implements CountsAccessor.Updater,
CountsAccessor.IndexStatsUpdater,
AutoCloseable {
    private final EntryUpdater<CountsKey> updater;

    public CountsUpdater(EntryUpdater<CountsKey> updater) {
        this.updater = updater;
    }

    @Override
    public void incrementNodeCount(int labelId, long delta) {
        try {
            this.updater.apply(CountsKeyFactory.nodeKey(labelId), CountsUpdater.incrementSecondBy(delta));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
        try {
            this.updater.apply(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId), CountsUpdater.incrementSecondBy(delta));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void replaceIndexUpdateAndSize(IndexDescriptor descriptor, long updates, long size) {
        try {
            this.updater.apply(CountsKeyFactory.indexStatisticsKey(descriptor), new Write(updates, size));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void replaceIndexSample(IndexDescriptor descriptor, long unique, long size) {
        try {
            this.updater.apply(CountsKeyFactory.indexSampleKey(descriptor), new Write(unique, size));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void incrementIndexUpdates(IndexDescriptor descriptor, long delta) {
        try {
            this.updater.apply(CountsKeyFactory.indexStatisticsKey(descriptor), CountsUpdater.incrementFirstBy(delta));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void close() {
        this.updater.close();
    }

    private static IncrementLong incrementFirstBy(long delta) {
        return new IncrementLong(0, delta);
    }

    private static IncrementLong incrementSecondBy(long delta) {
        return new IncrementLong(8, delta);
    }

    private static class IncrementLong
    implements ValueUpdate {
        private final int offset;
        private final long delta;

        private IncrementLong(int offset, long delta) {
            this.offset = offset;
            this.delta = delta;
        }

        @Override
        public void update(WritableBuffer target) {
            target.putLong(this.offset, target.getLong(this.offset) + this.delta);
        }
    }

    private static class Write
    implements ValueUpdate {
        private final long first;
        private final long second;

        Write(long first, long second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void update(WritableBuffer target) {
            target.putLong(0, this.first);
            target.putLong(8, this.second);
        }
    }
}

