/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.countStore;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.IndexDescriptorFactory;
import org.neo4j.kernel.api.schema.NodeMultiPropertyDescriptor;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshot;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;

public class CountsSnapshotDeserializer {
    public static CountsSnapshot deserialize(ReadableClosableChannel channel) throws IOException {
        long txid = channel.getLong();
        int size = channel.getInt();
        ConcurrentHashMap<CountsKey, long[]> map = new ConcurrentHashMap<CountsKey, long[]>(size);
        block7: for (int i = 0; i < size; ++i) {
            CountsKeyType type = CountsKeyType.value(channel.get());
            switch (type) {
                case ENTITY_NODE: {
                    CountsKey key = CountsKeyFactory.nodeKey(channel.getInt());
                    long[] value = new long[]{channel.getLong()};
                    map.put(key, value);
                    continue block7;
                }
                case ENTITY_RELATIONSHIP: {
                    int startLabelId = channel.getInt();
                    int typeId = channel.getInt();
                    int endLabelId = channel.getInt();
                    CountsKey key = CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId);
                    long[] value = new long[]{channel.getLong()};
                    map.put(key, value);
                    continue block7;
                }
                case INDEX_SAMPLE: {
                    IndexDescriptor descriptor = IndexDescriptorFactory.of(CountsSnapshotDeserializer.readNodePropertyDescriptor(channel));
                    CountsKey key = CountsKeyFactory.indexSampleKey(descriptor);
                    long[] value = new long[]{channel.getLong(), channel.getLong()};
                    map.put(key, value);
                    continue block7;
                }
                case INDEX_STATISTICS: {
                    IndexDescriptor descriptor = IndexDescriptorFactory.of(CountsSnapshotDeserializer.readNodePropertyDescriptor(channel));
                    CountsKey key = CountsKeyFactory.indexStatisticsKey(descriptor);
                    long[] value = new long[]{channel.getLong(), channel.getLong()};
                    map.put(key, value);
                    continue block7;
                }
                case EMPTY: {
                    throw new IllegalArgumentException("CountsKey of type EMPTY cannot be deserialized.");
                }
                default: {
                    throw new IllegalArgumentException("The read CountsKey has an unknown type.");
                }
            }
        }
        return new CountsSnapshot(txid, map);
    }

    private static NodePropertyDescriptor readNodePropertyDescriptor(ReadableClosableChannel channel) throws IOException {
        int labelId = channel.getInt();
        int length = channel.getShort();
        if (length > 1) {
            int[] propertyKeyIds = new int[length];
            for (int i = 0; i < length; ++i) {
                propertyKeyIds[i] = channel.getInt();
            }
            return new NodeMultiPropertyDescriptor(labelId, propertyKeyIds);
        }
        return new NodePropertyDescriptor(labelId, channel.getInt());
    }
}

