/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class TransactionToRecordStateVisitor
extends TxStateVisitor.Adapter {
    private boolean clearSchemaState;
    private final TransactionRecordState recordState;
    private final Runnable schemaStateChangeCallback;
    private final SchemaStorage schemaStorage;
    private final ConstraintSemantics constraintSemantics;
    private final SchemaIndexProviderMap schemaIndexProviderMap;

    public TransactionToRecordStateVisitor(TransactionRecordState recordState, Runnable schemaStateChangeCallback, SchemaStorage schemaStorage, ConstraintSemantics constraintSemantics, SchemaIndexProviderMap schemaIndexProviderMap) {
        this.recordState = recordState;
        this.schemaStateChangeCallback = schemaStateChangeCallback;
        this.schemaStorage = schemaStorage;
        this.constraintSemantics = constraintSemantics;
        this.schemaIndexProviderMap = schemaIndexProviderMap;
    }

    @Override
    public void close() {
        try {
            if (this.clearSchemaState) {
                this.schemaStateChangeCallback.run();
            }
        }
        finally {
            this.clearSchemaState = false;
        }
    }

    @Override
    public void visitCreatedNode(long id) {
        this.recordState.nodeCreate(id);
    }

    @Override
    public void visitDeletedNode(long id) {
        this.recordState.nodeDelete(id);
    }

    @Override
    public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
        this.recordState.relCreate(id, type, startNode, endNode);
    }

    @Override
    public void visitDeletedRelationship(long id) {
        this.recordState.relDelete(id);
    }

    @Override
    public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
        DefinedProperty prop;
        while (removed.hasNext()) {
            this.recordState.nodeRemoveProperty(id, removed.next());
        }
        while (changed.hasNext()) {
            prop = (DefinedProperty)changed.next();
            this.recordState.nodeChangeProperty(id, prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = (DefinedProperty)added.next();
            this.recordState.nodeAddProperty(id, prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
        DefinedProperty prop;
        while (removed.hasNext()) {
            this.recordState.relRemoveProperty(id, removed.next());
        }
        while (changed.hasNext()) {
            prop = (DefinedProperty)changed.next();
            this.recordState.relChangeProperty(id, prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = (DefinedProperty)added.next();
            this.recordState.relAddProperty(id, prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitGraphPropertyChanges(Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
        DefinedProperty prop;
        while (removed.hasNext()) {
            this.recordState.graphRemoveProperty(removed.next());
        }
        while (changed.hasNext()) {
            prop = (DefinedProperty)changed.next();
            this.recordState.graphChangeProperty(prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = (DefinedProperty)added.next();
            this.recordState.graphAddProperty(prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) {
        for (Integer label : removed) {
            this.recordState.removeLabelFromNode(label, id);
        }
        for (Integer label : added) {
            this.recordState.addLabelToNode(label, id);
        }
    }

    @Override
    public void visitAddedIndex(IndexDescriptor element, boolean isConstraintIndex) {
        SchemaIndexProvider.Descriptor providerDescriptor = this.schemaIndexProviderMap.getDefaultProvider().getProviderDescriptor();
        IndexRule rule = isConstraintIndex ? IndexRule.constraintIndexRule(this.schemaStorage.newRuleId(), element.descriptor(), providerDescriptor, null) : IndexRule.indexRule(this.schemaStorage.newRuleId(), element.descriptor(), providerDescriptor);
        this.recordState.createSchemaRule(rule);
    }

    @Override
    public void visitRemovedIndex(IndexDescriptor element, boolean isConstraintIndex) {
        SchemaStorage.IndexRuleKind kind = isConstraintIndex ? SchemaStorage.IndexRuleKind.CONSTRAINT : SchemaStorage.IndexRuleKind.INDEX;
        IndexRule rule = this.schemaStorage.indexRule(element.descriptor(), kind);
        this.recordState.dropSchemaRule(rule);
    }

    @Override
    public void visitAddedUniquePropertyConstraint(UniquenessConstraint element) {
        this.clearSchemaState = true;
        long constraintId = this.schemaStorage.newRuleId();
        IndexRule indexRule = this.schemaStorage.indexRule(element.descriptor(), SchemaStorage.IndexRuleKind.CONSTRAINT);
        this.recordState.createSchemaRule(this.constraintSemantics.writeUniquePropertyConstraint(constraintId, element.descriptor(), indexRule.getId()));
        this.recordState.setConstraintIndexOwner(indexRule, constraintId);
    }

    @Override
    public void visitRemovedUniquePropertyConstraint(UniquenessConstraint element) {
        try {
            this.clearSchemaState = true;
            UniquePropertyConstraintRule rule = this.schemaStorage.uniquenessConstraint(element.descriptor());
            this.recordState.dropSchemaRule(rule);
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException("Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
        }
        catch (DuplicateSchemaRuleException de) {
            throw new IllegalStateException("Multiple constraints found for specified label and property.");
        }
        this.visitRemovedIndex(element.indexDescriptor(), true);
    }

    @Override
    public void visitAddedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) throws CreateConstraintFailureException {
        this.clearSchemaState = true;
        this.recordState.createSchemaRule(this.constraintSemantics.writeNodePropertyExistenceConstraint(this.schemaStorage.newRuleId(), element.descriptor()));
    }

    @Override
    public void visitRemovedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) {
        try {
            this.clearSchemaState = true;
            this.recordState.dropSchemaRule(this.schemaStorage.nodePropertyExistenceConstraint(element.descriptor()));
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException("Node property existence constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
        }
        catch (DuplicateSchemaRuleException de) {
            throw new IllegalStateException("Multiple node property constraints found for specified label and property.");
        }
    }

    @Override
    public void visitAddedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) throws CreateConstraintFailureException {
        this.clearSchemaState = true;
        this.recordState.createSchemaRule(this.constraintSemantics.writeRelationshipPropertyExistenceConstraint(this.schemaStorage.newRuleId(), element.descriptor()));
    }

    @Override
    public void visitRemovedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) {
        try {
            this.clearSchemaState = true;
            RelationshipPropertyExistenceConstraintRule rule = this.schemaStorage.relationshipPropertyExistenceConstraint(element.descriptor().getRelationshipTypeId(), element.descriptor().getPropertyKeyId());
            this.recordState.dropSchemaRule(rule);
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException("Relationship property existence constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
        }
        catch (DuplicateSchemaRuleException re) {
            throw new IllegalStateException("Multiple relationship property constraints found for specified property and relationship type.");
        }
    }

    @Override
    public void visitCreatedLabelToken(String name, int id) {
        this.recordState.createLabelToken(name, id);
    }

    @Override
    public void visitCreatedPropertyKeyToken(String name, int id) {
        this.recordState.createPropertyKeyToken(name, id);
    }

    @Override
    public void visitCreatedRelationshipTypeToken(String name, int id) {
        this.recordState.createRelationshipTypeToken(name, id);
    }
}

