/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query.clientconnection;

import java.net.InetSocketAddress;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;

public class HttpConnectionInfo
extends ClientConnectionInfo {
    private final String scheme;
    private final InetSocketAddress clientAddress;
    private final InetSocketAddress serverAddress;
    private final String requestPath;

    public HttpConnectionInfo(String scheme, String userAgent, InetSocketAddress clientAddress, InetSocketAddress serverAddress, String requestPath) {
        this.scheme = scheme;
        this.clientAddress = clientAddress;
        this.serverAddress = serverAddress;
        this.requestPath = requestPath;
    }

    @Override
    public String asConnectionDetails() {
        return String.join((CharSequence)"\t", "server-session", this.scheme, this.clientAddress.getHostString(), this.requestPath);
    }

    @Override
    public String requestScheme() {
        return this.scheme;
    }

    @Override
    public String clientAddress() {
        return String.format("%s:%s", this.clientAddress.getHostString(), this.clientAddress.getPort());
    }

    @Override
    public String requestURI() {
        return this.serverAddress == null ? this.requestPath : String.format("%s://%s:%d%s", this.scheme, this.serverAddress.getHostString(), this.serverAddress.getPort(), this.requestPath);
    }
}

