/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.ArrayList;
import java.util.Arrays;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.IndexDescriptorFactory;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;

public class PropertyNameUtils {
    private PropertyNameUtils() {
    }

    private static String getPropertyKeyNameAt(Iterable<String> properties, int propertyKeyIndex) {
        for (String propertyKey : properties) {
            if (propertyKeyIndex == 0) {
                return propertyKey;
            }
            --propertyKeyIndex;
        }
        return null;
    }

    static IndexDescriptor getIndexDescriptor(ReadOperations readOperations, IndexDefinition index) throws SchemaRuleNotFoundException {
        int labelId = readOperations.labelGetForName(index.getLabel().name());
        int[] propertyKeyIds = PropertyNameUtils.getPropertyKeyIds(readOperations, index.getPropertyKeys());
        NodePropertyDescriptor descriptor = PropertyNameUtils.checkValidLabelAndProperties(index.getLabel(), labelId, propertyKeyIds, index.getPropertyKeys());
        return readOperations.indexGetForLabelAndPropertyKey(descriptor);
    }

    private static NodePropertyDescriptor checkValidLabelAndProperties(Label label, int labelId, int[] propertyKeyIds, Iterable<String> properties) {
        if (labelId == -1) {
            throw new NotFoundException(String.format("Label %s not found", label.name()));
        }
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            if (propertyKeyIds[i] != -1) continue;
            throw new NotFoundException(String.format("Property key %s not found", PropertyNameUtils.getPropertyKeyNameAt(properties, i)));
        }
        return IndexDescriptorFactory.getNodePropertyDescriptor(labelId, propertyKeyIds);
    }

    static IndexDescriptor getIndexDescriptor(ReadOperations readOperations, Label label, String[] propertyKeys) throws SchemaRuleNotFoundException {
        int labelId = readOperations.labelGetForName(label.name());
        int[] propertyKeyIds = PropertyNameUtils.getPropertyKeyIds(readOperations, propertyKeys);
        NodePropertyDescriptor descriptor = PropertyNameUtils.checkValidLabelAndProperties(label, labelId, propertyKeyIds, Arrays.asList(propertyKeys));
        return readOperations.indexGetForLabelAndPropertyKey(descriptor);
    }

    public static String[] getPropertyKeys(ReadOperations readOperations, NodePropertyDescriptor descriptor) throws PropertyKeyIdNotFoundKernelException {
        int[] nArray;
        if (descriptor.isComposite()) {
            nArray = descriptor.getPropertyKeyIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = descriptor.getPropertyKeyId();
        }
        int[] propertyKeyIds = nArray;
        String[] propertyKeys = new String[propertyKeyIds.length];
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            propertyKeys[i] = readOperations.propertyKeyGetName(propertyKeyIds[i]);
        }
        return propertyKeys;
    }

    public static String[] getPropertyKeys(TokenNameLookup tokenNameLookup, NodePropertyDescriptor descriptor) {
        int[] nArray;
        if (descriptor.isComposite()) {
            nArray = descriptor.getPropertyKeyIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = descriptor.getPropertyKeyId();
        }
        int[] propertyKeyIds = nArray;
        String[] propertyKeys = new String[propertyKeyIds.length];
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            propertyKeys[i] = tokenNameLookup.propertyKeyGetName(propertyKeyIds[i]);
        }
        return propertyKeys;
    }

    public static int[] getPropertyKeyIds(ReadOperations statement, String[] propertyKeys) {
        int[] propertyKeyIds = new int[propertyKeys.length];
        for (int i = 0; i < propertyKeys.length; ++i) {
            propertyKeyIds[i] = statement.propertyKeyGetForName(propertyKeys[i]);
        }
        return propertyKeyIds;
    }

    public static int[] getPropertyKeyIds(ReadOperations statement, Iterable<String> propertyKeys) {
        return Iterables.stream(propertyKeys).mapToInt(statement::propertyKeyGetForName).toArray();
    }

    public static int[] getOrCreatePropertyKeyIds(SchemaWriteOperations statement, String[] propertyKeys) throws IllegalTokenNameException {
        int[] propertyKeyIds = new int[propertyKeys.length];
        for (int i = 0; i < propertyKeys.length; ++i) {
            propertyKeyIds[i] = statement.propertyKeyGetOrCreateForName(propertyKeys[i]);
        }
        return propertyKeyIds;
    }

    public static int[] getOrCreatePropertyKeyIds(SchemaWriteOperations statement, IndexDefinition indexDefinition) throws IllegalTokenNameException {
        ArrayList<Integer> propertyKeyIds = new ArrayList<Integer>();
        for (String s : indexDefinition.getPropertyKeys()) {
            propertyKeyIds.add(statement.propertyKeyGetOrCreateForName(s));
        }
        return propertyKeyIds.stream().mapToInt(i -> i).toArray();
    }
}

