/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.EntityItemHelper;
import org.neo4j.kernel.impl.api.store.DegreeCounter;
import org.neo4j.kernel.impl.api.store.NodeExploringCursors;
import org.neo4j.kernel.impl.api.store.RelationshipTypeCursor;
import org.neo4j.kernel.impl.api.store.RelationshipTypeDenseCursor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.DegreeItem;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.RelationshipTypeItem;

public class StoreSingleNodeCursor
extends EntityItemHelper
implements Cursor<NodeItem>,
NodeItem {
    private final NodeRecord nodeRecord;
    private final RelationshipStore relationshipStore;
    private final RecordStore<RelationshipGroupRecord> relationshipGroupStore;
    private final Consumer<StoreSingleNodeCursor> instanceCache;
    private final LockService lockService;
    private final RecordCursors recordCursors;
    private final NodeExploringCursors cursors;
    private long nodeId = -1L;

    StoreSingleNodeCursor(NodeRecord nodeRecord, NeoStores neoStores, Consumer<StoreSingleNodeCursor> instanceCache, RecordCursors recordCursors, LockService lockService) {
        this.nodeRecord = nodeRecord;
        this.recordCursors = recordCursors;
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.lockService = lockService;
        this.instanceCache = instanceCache;
        this.cursors = new NodeExploringCursors(recordCursors, lockService, this.relationshipStore, this.relationshipGroupStore);
    }

    public StoreSingleNodeCursor init(long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public NodeItem get() {
        return this;
    }

    public boolean next() {
        if (this.nodeId != -1L) {
            try {
                boolean bl = this.recordCursors.node().next(this.nodeId, this.nodeRecord, RecordLoad.CHECK);
                return bl;
            }
            finally {
                this.nodeId = -1L;
            }
        }
        return false;
    }

    public void close() {
        this.instanceCache.accept(this);
    }

    @Override
    public long id() {
        return this.nodeRecord.getId();
    }

    @Override
    public Cursor<LabelItem> labels() {
        return this.cursors.labels(this.nodeRecord);
    }

    @Override
    public Cursor<LabelItem> label(int labelId) {
        return this.cursors.label(this.nodeRecord, labelId);
    }

    @Override
    public boolean hasLabel(int labelId) {
        return this.label(labelId).exists();
    }

    private Lock shortLivedReadLock() {
        Lock lock = this.lockService.acquireNodeLock(this.nodeRecord.getId(), LockService.LockType.READ_LOCK);
        if (this.lockService != LockService.NO_LOCK_SERVICE) {
            boolean success = false;
            try {
                if (!this.recordCursors.node().next(this.nodeRecord.getId(), this.nodeRecord, RecordLoad.CHECK)) {
                    this.nodeRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
                }
                success = true;
            }
            finally {
                if (!success) {
                    lock.release();
                }
            }
        }
        return lock;
    }

    @Override
    public Cursor<PropertyItem> properties() {
        return this.cursors.properties(this.nodeRecord.getNextProp(), this.shortLivedReadLock());
    }

    @Override
    public Cursor<PropertyItem> property(int propertyKeyId) {
        return this.cursors.property(this.nodeRecord.getNextProp(), propertyKeyId, this.shortLivedReadLock());
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction) {
        return this.cursors.relationships(this.nodeRecord.isDense(), this.nodeRecord.getNextRel(), this.nodeRecord.getId(), direction);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction, int ... relTypes) {
        return this.cursors.relationships(this.nodeRecord.isDense(), this.nodeRecord.getNextRel(), this.nodeRecord.getId(), direction, relTypes);
    }

    @Override
    public Cursor<RelationshipTypeItem> relationshipTypes() {
        if (this.nodeRecord.isDense()) {
            long groupId = this.nodeRecord.getNextRel();
            return new RelationshipTypeDenseCursor(groupId, this.relationshipGroupStore.newRecord(), this.recordCursors);
        }
        return new RelationshipTypeCursor(this.relationships(Direction.BOTH));
    }

    @Override
    public int degree(Direction direction) {
        if (this.nodeRecord.isDense()) {
            return DegreeCounter.countRelationshipsInGroup(this.nodeRecord.getNextRel(), direction, null, this.nodeRecord, (RelationshipRecord)this.relationshipStore.newRecord(), this.relationshipGroupStore.newRecord(), this.recordCursors);
        }
        return this.relationships(direction).count();
    }

    @Override
    public int degree(Direction direction, int relType) {
        if (this.nodeRecord.isDense()) {
            return DegreeCounter.countRelationshipsInGroup(this.nodeRecord.getNextRel(), direction, relType, this.nodeRecord, (RelationshipRecord)this.relationshipStore.newRecord(), this.relationshipGroupStore.newRecord(), this.recordCursors);
        }
        return this.relationships(direction, relType).count();
    }

    @Override
    public Cursor<DegreeItem> degrees() {
        return this.nodeRecord.isDense() ? this.cursors.degrees(this.nodeRecord.getNextRel(), this.nodeRecord, this.recordCursors) : this.cursors.degrees(this.buildDegreeMap());
    }

    private PrimitiveIntObjectMap<int[]> buildDegreeMap() {
        return (PrimitiveIntObjectMap)this.relationships(Direction.BOTH).mapReduce((Object)Primitive.intObjectMap((int)5), Function.identity(), (rel, currentDegrees) -> {
            int[] byType = (int[])currentDegrees.get(rel.type());
            if (byType == null) {
                byType = new int[3];
                currentDegrees.put(rel.type(), (Object)byType);
            }
            int n = this.directionOf(this.nodeRecord.getId(), rel.id(), rel.startNode(), rel.endNode()).ordinal();
            byType[n] = byType[n] + 1;
            return currentDegrees;
        });
    }

    @Override
    public boolean isDense() {
        return this.nodeRecord.isDense();
    }

    private Direction directionOf(long nodeId, long relationshipId, long startNode, long endNode) {
        if (startNode == nodeId) {
            return endNode == nodeId ? Direction.BOTH : Direction.OUTGOING;
        }
        if (endNode == nodeId) {
            return Direction.INCOMING;
        }
        throw new InvalidRecordException("Node " + nodeId + " neither start nor end node of relationship " + relationshipId + " with startNode:" + startNode + " and endNode:" + endNode);
    }
}

