/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.IndexDescriptorFactory;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.api.schema.RelationshipPropertyDescriptor;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodePropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyConstraintRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaCache {
    private final Map<Long, SchemaRule> rulesByIdMap = new HashMap<Long, SchemaRule>();
    private final Collection<NodePropertyConstraint> nodeConstraints = new HashSet<NodePropertyConstraint>();
    private final Collection<RelationshipPropertyConstraint> relationshipConstraints = new HashSet<RelationshipPropertyConstraint>();
    private final Set<IndexDescriptor> indexDescriptors = new HashSet<IndexDescriptor>();
    private final ConstraintSemantics constraintSemantics;

    public SchemaCache(ConstraintSemantics constraintSemantics, Iterable<SchemaRule> initialRules) {
        this.constraintSemantics = constraintSemantics;
        this.splitUpInitialRules(initialRules);
    }

    private void splitUpInitialRules(Iterable<SchemaRule> initialRules) {
        for (SchemaRule rule : initialRules) {
            this.addSchemaRule(rule);
        }
    }

    public Iterable<SchemaRule> schemaRules() {
        return this.rulesByIdMap.values();
    }

    public Iterable<SchemaRule> schemaRulesForLabel(int label) {
        return Iterables.filter(schemaRule -> schemaRule.getKind() != SchemaRule.Kind.RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT && schemaRule.getLabel() == label, this.schemaRules());
    }

    public Iterable<SchemaRule> schemaRulesForRelationshipType(int typeId) {
        return Iterables.filter(schemaRule -> schemaRule.getKind() == SchemaRule.Kind.RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT && schemaRule.getRelationshipType() == typeId, this.schemaRules());
    }

    public Iterator<PropertyConstraint> constraints() {
        return Iterators.concat((Iterator[])new Iterator[]{this.nodeConstraints.iterator(), this.relationshipConstraints.iterator()});
    }

    public Iterator<NodePropertyConstraint> constraintsForLabel(int label) {
        return Iterators.filter(constraint -> constraint.label() == label, this.nodeConstraints.iterator());
    }

    public Iterator<NodePropertyConstraint> constraintsForLabelAndProperty(NodePropertyDescriptor descriptor) {
        return Iterators.filter(constraint -> constraint.matches(descriptor), this.nodeConstraints.iterator());
    }

    public Iterator<RelationshipPropertyConstraint> constraintsForRelationshipType(int typeId) {
        return Iterators.filter(constraint -> constraint.descriptor().getRelationshipTypeId() == typeId, this.relationshipConstraints.iterator());
    }

    public Iterator<RelationshipPropertyConstraint> constraintsForRelationshipTypeAndProperty(RelationshipPropertyDescriptor descriptor) {
        return Iterators.filter(constraint -> constraint.matches(descriptor), this.relationshipConstraints.iterator());
    }

    public void addSchemaRule(SchemaRule rule) {
        IndexRule indexRule;
        IndexDescriptor index;
        this.rulesByIdMap.put(rule.getId(), rule);
        if (rule instanceof PropertyConstraintRule) {
            PropertyConstraint constraint = this.constraintSemantics.readConstraint((PropertyConstraintRule)rule);
            if (constraint instanceof NodePropertyConstraint) {
                this.nodeConstraints.add((NodePropertyConstraint)constraint);
            } else if (constraint instanceof RelationshipPropertyConstraint) {
                this.relationshipConstraints.add((RelationshipPropertyConstraint)constraint);
            }
        } else if (rule instanceof IndexRule && !this.indexDescriptors.contains(index = IndexDescriptorFactory.of(indexRule = (IndexRule)rule))) {
            this.indexDescriptors.add(index);
        }
    }

    public void clear() {
        this.rulesByIdMap.clear();
        this.nodeConstraints.clear();
        this.relationshipConstraints.clear();
        this.indexDescriptors.clear();
    }

    public void load(List<SchemaRule> schemaRuleIterator) {
        this.clear();
        for (SchemaRule schemaRule : schemaRuleIterator) {
            this.addSchemaRule(schemaRule);
        }
    }

    public void removeSchemaRule(long id) {
        SchemaRule rule = this.rulesByIdMap.remove(id);
        if (rule == null) {
            return;
        }
        if (rule instanceof NodePropertyConstraintRule) {
            this.nodeConstraints.remove(((NodePropertyConstraintRule)rule).toConstraint());
        } else if (rule instanceof RelationshipPropertyConstraintRule) {
            this.relationshipConstraints.remove(((RelationshipPropertyConstraintRule)rule).toConstraint());
        } else if (rule instanceof IndexRule) {
            IndexRule indexRule = (IndexRule)rule;
            this.indexDescriptors.remove(IndexDescriptorFactory.of(indexRule));
        }
    }

    public IndexDescriptor indexDescriptor(NodePropertyDescriptor descriptor) {
        IndexDescriptor indexDescriptor = IndexDescriptorFactory.of(descriptor);
        return this.indexDescriptors.contains(indexDescriptor) ? indexDescriptor : null;
    }
}

